/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.nautilus;

import com.caucho.env.actor.ActorQueue;
import com.caucho.message.broker.BrokerSender;
import com.caucho.message.broker.SenderSettleHandler;
import com.caucho.message.nautilus.NautilusRingItem;
import com.caucho.vfs.TempBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NautilusBrokerPublisher
implements BrokerSender {
    private ActorQueue<NautilusRingItem> _nautilusQueue;
    private final long _qid;
    private long _mid;

    NautilusBrokerPublisher(long qid, ActorQueue<NautilusRingItem> actorQueue) {
        this._qid = qid;
        this._nautilusQueue = actorQueue;
    }

    @Override
    public int getPrefetch() {
        return this._nautilusQueue.getAvailable();
    }

    @Override
    public long nextMessageId() {
        return ++this._mid;
    }

    @Override
    public void message(long xid, long mid, boolean isDurable, int priority, long expireTime, byte[] buffer, int offset, int length, TempBuffer tBuf, SenderSettleHandler settleHandler) {
        NautilusRingItem entry = this._nautilusQueue.startOffer(true);
        entry.initMessage(xid, this._qid, mid, isDurable, priority, expireTime, buffer, offset, length, tBuf);
        this._nautilusQueue.finishOffer(entry);
        this._nautilusQueue.wake();
    }

    @Override
    public void close() {
    }
}

