/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.journal;

import com.caucho.db.block.Block;
import com.caucho.db.block.BlockStore;
import com.caucho.message.journal.JournalRecoverListener;
import com.caucho.message.journal.JournalResult;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;

public final class JournalFile {
    private static final L10N L = new L10N(JournalFile.class);
    public static final int BLOCK_BITS = 13;
    public static final int BLOCK_SIZE = 8192;
    public static final long FILE_HEADER_OFFSET = 16384L;
    public static final int FILE_HEADER_SIZE = 8192;
    public static final int MIN_BLOCK_COUNT = 4;
    public static final long FILE_DATA_OFFSET = 32768L;
    public static final int FH_OFF_PAGE = 0;
    public static final int FH_PAGE_MASK = 3;
    public static final int FH_CHECKPOINT_ADDR = 8;
    public static final int FH_CHECKPOINT_OFFSET = 16;
    public static final int FH_END = 24;
    public static final int MIN_FLIP_SIZE = 256;
    public static final int PAD_SIZE = 128;
    public static final int PAD_MASK = 127;
    public static final int HOFF_LENGTH = 0;
    public static final int HOFF_CODE = 2;
    public static final int HOFF_QID = 8;
    public static final int HOFF_MID = 16;
    public static final int HOFF_XID = 24;
    public static final int HEADER_SIZE = 32;
    public static final int H_LENGTH_MASK = 8191;
    public static final int H_PAGE = 57344;
    public static final int H_PAGE_OFF = 11;
    public static final long H_FIN = 0x800000000000L;
    public static final long H_INIT = 0x400000000000L;
    public static final long H_CODE_MASK = 0x3FFFFFFFFFFFL;
    public static final int OP_NULL = 0;
    public static final int OP_CHECKPOINT = 1;
    private final Path _path;
    private BlockStore _blockStore;
    private long _flipAddress;
    private boolean _isFlipFree;
    private boolean _isFlipA;
    private long _tailAddress;
    private int _tailOffset;
    private Block _tailBlock;
    private Block _headerBlockA;
    private Block _headerBlockB;
    private int _page;

    public JournalFile(Path path, JournalRecoverListener listener) {
        this._path = path;
        if (path == null) {
            throw new NullPointerException();
        }
        if (listener == null) {
            throw new NullPointerException();
        }
        this.setMinFlipSize(262144L);
        this.init(listener);
        this.validateConstants();
    }

    private void validateConstants() {
    }

    public void setMinFlipSize(long size) {
        if ((size += (8192L - size % 8192L) % 8192L) < 16384L) {
            size = 16384L;
        }
        int count = (int)(size / 8192L);
        this._flipAddress = (long)(16384 * count) + 32768L;
    }

    public static boolean isSamePage(long addressA, long addressB) {
        return (addressA & 0x2000L) == (addressB & 0x2000L);
    }

    private void init(JournalRecoverListener listener) {
        try {
            this._blockStore = BlockStore.create(this._path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this._tailAddress = 32768L;
        this._tailOffset = 0;
        this._isFlipFree = true;
        try {
            long headerAddrA = 16384L;
            this._headerBlockA = this._blockStore.readBlock(headerAddrA);
            long headerAddrB = 24576L;
            this._headerBlockB = this._blockStore.readBlock(headerAddrB);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.recover(listener);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void recover(JournalRecoverListener listener) throws IOException {
        boolean isFlipA;
        int nextA;
        long fileSize = this._path.getLength();
        Block block = null;
        int seqA = 0;
        long checkpointAddrA = 0L;
        int checkpointOffsetA = 0;
        int seqB = 0;
        long checkpointAddrB = 0L;
        int checkpointOffsetB = 0;
        block = this._headerBlockA;
        byte[] buffer = block.getBuffer();
        seqA = buffer[0] & 3;
        if ((seqA & 1) != 0) {
            seqA = 0;
        }
        checkpointAddrA = JournalFile.readLong(buffer, 8);
        checkpointOffsetA = JournalFile.readInt(buffer, 16);
        if (checkpointAddrA < 32768L) {
            checkpointAddrA = 32768L;
        }
        if (((seqB = (buffer = (block = this._headerBlockB).getBuffer())[0] & 3) & 1) != 1) {
            seqB = 0;
        }
        checkpointAddrB = JournalFile.readLong(buffer, 8);
        checkpointOffsetB = JournalFile.readInt(buffer, 16);
        if (checkpointAddrB < 40960L) {
            checkpointAddrB = 40960L;
        }
        if ((nextA = seqA + 1 & 3) == 0) {
            nextA = 2;
        }
        boolean bl = isFlipA = nextA != seqB;
        if (seqA == 0) {
            this._page = 3;
            this._isFlipA = false;
            this.flip();
            this._isFlipFree = true;
            return;
        }
        boolean isFlipFree = true;
        this._page = isFlipA ? seqB : seqA;
        this._tailAddress = isFlipA ? checkpointAddrB : checkpointAddrA;
        int n = this._tailOffset = isFlipA ? checkpointOffsetB : checkpointOffsetA;
        if (this._tailOffset < 8192 && this._tailAddress < fileSize & this._page != 0) {
            try {
                while (this.recoverEntry(listener)) {
                    isFlipFree = false;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this._page = isFlipA ? seqA : seqB;
        this._tailAddress = isFlipA ? checkpointAddrA : checkpointAddrB;
        this._tailOffset = isFlipA ? checkpointOffsetA : checkpointOffsetB;
        boolean isRecover = false;
        if (this._tailOffset < 8192 && this._tailAddress < fileSize & this._page != 0) {
            try {
                while (this.recoverEntry(listener)) {
                    isRecover = true;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this._isFlipFree = isFlipFree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recoverEntry(JournalRecoverListener listener) throws IOException {
        long xid;
        long mid;
        long qid;
        boolean isInit;
        boolean isFin;
        long code;
        int len;
        Block block;
        int i;
        long tailAddress;
        block5: {
            tailAddress = this._tailAddress;
            i = this._tailOffset;
            block = this._blockStore.readBlock(tailAddress);
            try {
                block.read();
                byte[] buffer = block.getBuffer();
                len = JournalFile.readShort(buffer, i + 0);
                int page = len >> 11;
                len &= 0x1FFF;
                code = JournalFile.readCode(buffer, i + 2);
                isFin = (code & 0x800000000000L) != 0L;
                isInit = (code & 0x400000000000L) != 0L;
                code &= 0x3FFFFFFFFFFFL;
                qid = JournalFile.readLong(buffer, i + 8);
                mid = JournalFile.readLong(buffer, i + 16);
                xid = JournalFile.readLong(buffer, i + 24);
                i += 32;
                if (page == this._page && buffer.length > len) break block5;
                boolean bl = false;
                Object var21_16 = null;
                block.free();
                return bl;
            }
            catch (Throwable throwable) {
                Object var21_18 = null;
                block.free();
                throw throwable;
            }
        }
        int offset = i;
        i += len;
        i += 128 - i & 0x7F;
        if (8192 <= i) {
            this._tailAddress = tailAddress + 16384L;
            this._tailOffset = 0;
        } else {
            this._tailOffset = i;
        }
        listener.onEntry(code, isInit, isFin, xid, qid, mid, this._blockStore, tailAddress, offset, len);
        Object var21_17 = null;
        block.free();
        return true;
    }

    public final void write(long code, boolean isInit, boolean isFin, long xid, long qid, long mid, byte[] buffer, int offset, int length, JournalResult result) throws IOException {
        int sublen;
        if ((code & 0xFFFFC00000000000L) != 0L) {
            throw new IllegalArgumentException(L.l("invalid code 0x{0}", (Object)Long.toHexString(code)));
        }
        boolean isFirst = true;
        do {
            if (length <= (sublen = this.writeImpl(code, isInit, isFin, xid, qid, mid, buffer, offset, length, result, isFirst)) && isFirst) {
                result.init2(0L, 0, 0);
                break;
            }
            isFirst = false;
            isInit = false;
            offset += sublen;
        } while ((length -= sublen) > 0);
        if (this._flipAddress < this._tailAddress && this._isFlipFree) {
            this.flip();
        }
    }

    private int writeImpl(long code, boolean isInit, boolean isFin, long xid, long qid, long mid, byte[] buffer, int offset, int length, JournalResult result, boolean isFirst) throws IOException {
        int i;
        byte[] tailBuffer;
        int sublen;
        if (this._tailBlock == null) {
            this._tailBlock = this._blockStore.readBlock(this._tailAddress);
        }
        if (length < (sublen = (tailBuffer = this._tailBlock.getBuffer()).length - (i = this._tailOffset) - 32)) {
            sublen = length;
            isInit = false;
        }
        int hLength = sublen + (this._page << 11);
        tailBuffer[i + 0 + 0] = (byte)(hLength >> 8);
        tailBuffer[i + 0 + 1] = (byte)hLength;
        if (isInit) {
            code |= 0x400000000000L;
        }
        if (isFin) {
            code |= 0x800000000000L;
        }
        JournalFile.writeCode(tailBuffer, i + 2, code);
        JournalFile.writeLong(tailBuffer, i + 24, xid);
        JournalFile.writeLong(tailBuffer, i + 8, qid);
        JournalFile.writeLong(tailBuffer, i + 16, mid);
        System.arraycopy(buffer, offset, tailBuffer, i += 32, sublen);
        if (isFirst) {
            result.init1(this._blockStore, this._tailAddress, i, sublen);
        } else {
            result.init2(this._tailAddress, i, sublen);
        }
        i += sublen;
        i += 128 - i & 0x7F;
        this._tailBlock.setDirtyExact(0, i);
        if (i == 8192) {
            Block block = this._tailBlock;
            this._tailBlock = null;
            block.free();
            block.commit();
            this._tailAddress += 16384L;
            this._tailOffset = 0;
        } else {
            this._tailOffset = i;
        }
        return sublen;
    }

    public void checkpoint(long blockAddr, int offset, int length) throws IOException {
        int tail = offset + length;
        if (8192 <= (tail += 128 - tail & 0x7F)) {
            blockAddr += 16384L;
            tail = 0;
        }
        boolean isCheckpointA = (blockAddr >> 13 & 1L) == 0L;
        Block block = isCheckpointA ? this._headerBlockA : this._headerBlockB;
        byte[] buffer = block.getBuffer();
        JournalFile.writeLong(buffer, 8, blockAddr);
        JournalFile.writeInt(buffer, 16, tail);
        block.setDirtyExact(0, 24);
        if (isCheckpointA == this._isFlipA && !this._isFlipFree) {
            block = isCheckpointA ? this._headerBlockB : this._headerBlockA;
            buffer = block.getBuffer();
            JournalFile.writeLong(buffer, 8, 0L);
            JournalFile.writeInt(buffer, 16, 0x3FFFFFFF);
            block.setDirtyExact(0, 24);
            this._isFlipFree = true;
            this._headerBlockA.commit();
            this._headerBlockB.commit();
        }
    }

    private void flip() throws IOException {
        int nextPage;
        Block tailBlock = this._tailBlock;
        this._tailBlock = null;
        if (tailBlock != null) {
            tailBlock.free();
            tailBlock.commit();
        }
        if ((nextPage = this._page + 1 & 3) < 2) {
            nextPage = 2;
        }
        this._page = nextPage;
        this._isFlipA = (nextPage & 1) == 0;
        this._tailAddress = 32768L + (long)(this._isFlipA ? 0 : 8192);
        this._tailOffset = 0;
        this._isFlipFree = false;
        Block block = this._isFlipA ? this._headerBlockA : this._headerBlockB;
        byte[] buffer = block.getBuffer();
        buffer[0] = (byte)this._page;
        JournalFile.writeLong(buffer, 8, 0L);
        JournalFile.writeLong(buffer, 16, 0L);
        block.setDirtyExact(0, 24);
    }

    private static int readShort(byte[] buffer, int offset) {
        return ((buffer[offset] & 0xFF) << 8) + (buffer[offset + 1] & 0xFF);
    }

    private static int readInt(byte[] buffer, int offset) {
        return ((buffer[offset + 0] & 0xFF) << 24) + ((buffer[offset + 1] & 0xFF) << 16) + ((buffer[offset + 2] & 0xFF) << 8) + (buffer[offset + 3] & 0xFF);
    }

    private static void writeInt(byte[] buffer, int offset, int value) {
        buffer[offset + 0] = (byte)(value >> 24);
        buffer[offset + 1] = (byte)(value >> 16);
        buffer[offset + 2] = (byte)(value >> 8);
        buffer[offset + 3] = (byte)(value >> 0);
    }

    private static long readCode(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 40) + (((long)buffer[offset + 1] & 0xFFL) << 32) + (((long)buffer[offset + 2] & 0xFFL) << 24) + (((long)buffer[offset + 3] & 0xFFL) << 16) + (((long)buffer[offset + 4] & 0xFFL) << 8) + ((long)buffer[offset + 5] & 0xFFL);
    }

    private static void writeCode(byte[] buffer, int offset, long value) {
        buffer[offset + 0] = (byte)(value >> 40);
        buffer[offset + 1] = (byte)(value >> 32);
        buffer[offset + 2] = (byte)(value >> 24);
        buffer[offset + 3] = (byte)(value >> 16);
        buffer[offset + 4] = (byte)(value >> 8);
        buffer[offset + 5] = (byte)(value >> 0);
    }

    private static long readLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
    }

    private static void writeLong(byte[] buffer, int offset, long value) {
        buffer[offset + 0] = (byte)(value >> 56);
        buffer[offset + 1] = (byte)(value >> 48);
        buffer[offset + 2] = (byte)(value >> 40);
        buffer[offset + 3] = (byte)(value >> 32);
        buffer[offset + 4] = (byte)(value >> 24);
        buffer[offset + 5] = (byte)(value >> 16);
        buffer[offset + 6] = (byte)(value >> 8);
        buffer[offset + 7] = (byte)(value >> 0);
    }

    public void close() {
        Block tailBlock = this._tailBlock;
        this._tailBlock = null;
        Block headerBlockA = this._headerBlockA;
        this._headerBlockA = null;
        Block headerBlockB = this._headerBlockB;
        this._headerBlockB = null;
        if (tailBlock != null) {
            tailBlock.free();
        }
        if (headerBlockA != null) {
            headerBlockA.free();
        }
        if (headerBlockB != null) {
            headerBlockB.free();
        }
        this._blockStore.flush();
        this._blockStore.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._path + "]";
    }
}

