/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.common;

public final class MessageReceiverCredit {
    private int _prefetch;
    private int _creditHighLimit;
    private int _creditLowLimit;
    private boolean _isHighUpdate;
    private volatile long _endpointSequence;
    private volatile long _clientSequence;
    private volatile long _creditEnd;

    public final int getPrefetch() {
        return this._prefetch;
    }

    public final void setPrefetch(int prefetch) {
        this._prefetch = prefetch;
        this._creditHighLimit = (int)((double)prefetch * 0.75);
        this._creditLowLimit = Math.min(Math.max(2, (int)((double)prefetch * 0.25)), prefetch);
    }

    public final long getEndpointSequence() {
        return this._endpointSequence;
    }

    public final long receiveEndpoint() {
        return this._endpointSequence++;
    }

    public final long getClientSequence() {
        return this._clientSequence;
    }

    public final void receiveClient() {
        ++this._clientSequence;
    }

    public final long getCreditAvailable() {
        return this._creditEnd - this._endpointSequence;
    }

    public final long getQueueSize() {
        return this._endpointSequence - this._clientSequence;
    }

    public final int getCredit() {
        return (int)((long)this._prefetch - this.getQueueSize());
    }

    public final boolean isFlowRequired() {
        long clientQueueAvailable = this.getCredit();
        if (clientQueueAvailable == 0L) {
            return false;
        }
        long creditAvailable = this.getCreditAvailable();
        if (creditAvailable <= (long)this._creditLowLimit) {
            return true;
        }
        if (creditAvailable <= (long)this._creditHighLimit && !this._isHighUpdate) {
            this._isHighUpdate = true;
            return true;
        }
        return false;
    }

    public final void updateCredit(int credit) {
        long creditEnd;
        this._creditEnd = creditEnd = this._endpointSequence + (long)credit;
        this._isHighUpdate = false;
    }
}

