/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.management.server;

import com.caucho.util.CurrentTime;
import java.io.Serializable;

public class TcpConnectionInfo
implements Serializable {
    private final int _id;
    private final long _threadId;
    private final String _address;
    private final int _port;
    private final String _state;
    private final long _requestStartTime;
    private String _remoteAddress;
    private String _url;

    private TcpConnectionInfo() {
        this._id = 0;
        this._threadId = 0L;
        this._address = null;
        this._port = 0;
        this._state = null;
        this._requestStartTime = 0L;
        this._remoteAddress = null;
        this._url = null;
    }

    public TcpConnectionInfo(int id, long threadId, String address, int port, String state, long requestStartTime) {
        this._id = id;
        this._threadId = threadId;
        this._address = address;
        this._port = port;
        this._state = state;
        this._requestStartTime = requestStartTime;
    }

    public int getId() {
        return this._id;
    }

    public long getThreadId() {
        return this._threadId;
    }

    public String getAddress() {
        return this._address;
    }

    public int getPort() {
        return this._port;
    }

    public String getPortName() {
        return (this._address == null ? "*" : this._address) + ":" + this._port;
    }

    public String getState() {
        return this._state;
    }

    public boolean hasRequest() {
        return this._requestStartTime > 0L;
    }

    public long getRequestStartTime() {
        return this._requestStartTime;
    }

    public long getRequestActiveTime() {
        if (this._requestStartTime > 0L) {
            return CurrentTime.getCurrentTime() - this._requestStartTime;
        }
        return -1L;
    }

    public void setRemoteAddress(String remoteAddress) {
        this._remoteAddress = remoteAddress;
    }

    public String getRemoteAddress() {
        return this._remoteAddress;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public String getUrl() {
        return this._url;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "," + this.getPortName() + "]";
    }
}

