/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.management.server;

import com.caucho.jmx.Description;
import com.caucho.jmx.MXAction;
import com.caucho.jmx.MXContentType;
import com.caucho.jmx.MXParam;
import com.caucho.management.server.ManagedObjectMXBean;
import com.caucho.server.admin.AddUserQueryReply;
import com.caucho.server.admin.JmxCallQueryReply;
import com.caucho.server.admin.JmxSetQueryReply;
import com.caucho.server.admin.JsonQueryReply;
import com.caucho.server.admin.ListJmxQueryReply;
import com.caucho.server.admin.ListUsersQueryReply;
import com.caucho.server.admin.PdfReportQueryReply;
import com.caucho.server.admin.RemoveUserQueryReply;
import com.caucho.server.admin.StatServiceValuesQueryReply;
import com.caucho.server.admin.StringQueryReply;
import com.caucho.server.deploy.DeployControllerState;
import com.caucho.server.deploy.DeployTagResult;
import java.io.InputStream;
import java.util.Date;
import javax.management.ReflectionException;

@Description(value="Management Facade for Resin")
public interface ManagementMXBean
extends ManagedObjectMXBean {
    @Description(value="deploys configuration")
    @MXAction(value="config-deploy", method="POST")
    @MXContentType
    public String configDeploy(@MXParam(name="server") String var1, @MXParam(name="stage") String var2, @MXParam(name="version") String var3, @MXParam(name="message") String var4, InputStream var5) throws ReflectionException;

    @Description(value="pulls a configuration file")
    @MXAction(value="config-cat", method="GET")
    @MXContentType(value="text/xml")
    public InputStream configCat(@MXParam(name="server") String var1, @MXParam(name="name", required=true) String var2, @MXParam(name="stage") String var3, @MXParam(name="version") String var4) throws ReflectionException;

    @Description(value="list the configuration files")
    @MXAction(value="config-ls", method="GET")
    @MXContentType
    public String[] configLs(@MXParam(name="server") String var1, @MXParam(name="name") String var2, @MXParam(name="stage") String var3, @MXParam(name="version") String var4) throws ReflectionException;

    @Description(value="undeploy configuration")
    @MXAction(value="config-undeploy", method="POST")
    @MXContentType
    public String configUndeploy(@MXParam(name="server") String var1, @MXParam(name="stage") String var2, @MXParam(name="version") String var3, @MXParam(name="message") String var4) throws ReflectionException;

    @Description(value="Produces a complete dump of JMX objects and values")
    @MXAction(value="jmx-dump")
    public JsonQueryReply doJmxDump(@MXParam(name="server") String var1) throws ReflectionException;

    @Description(value="lists the JMX MBeans in a Resin server (Resin Pro)")
    @MXAction(value="jmx-list")
    @MXContentType
    public ListJmxQueryReply listJmx(@MXParam(name="server") String var1, @MXParam(name="pattern") String var2, @MXParam(name="print-attributes") boolean var3, @MXParam(name="print-values") boolean var4, @MXParam(name="print-operations") boolean var5, @MXParam(name="print-all-beans") boolean var6, @MXParam(name="print-platform-beans") boolean var7) throws ReflectionException;

    @Description(value="sets the java.util.logging level for debugging (Resin Pro)")
    @MXAction(value="log-level", method="POST")
    @MXContentType
    public StringQueryReply setLogLevel(@MXParam(name="server") String var1, @MXParam(name="loggers") String var2, @MXParam(name="level", required=true) String var3, @MXParam(name="active-time") String var4) throws ReflectionException;

    @Description(value="creates a PDF report of a Resin server (Resin Pro)")
    @MXAction(value="pdf-report", method="GET")
    @MXContentType
    public PdfReportQueryReply pdfReport(@MXParam(name="server") String var1, @MXParam(name="report") String var2, @MXParam(name="period") String var3, @MXParam(name="log-directory") String var4, @MXParam(name="profile-time") String var5, @MXParam(name="sample-period") String var6, @MXParam(name="snapshot", defaultValue="true") boolean var7, @MXParam(name="watchdog") boolean var8, @MXParam(name="load-pdf") boolean var9) throws ReflectionException;

    @Description(value="outputs stats collected by a named meter")
    @MXAction(value="stats", method="GET")
    @MXContentType
    public StatServiceValuesQueryReply getStats(@MXParam(name="server") String var1, @MXParam(name="meters", required=true) String var2, @MXParam(name="period", defaultValue="7D") String var3) throws ReflectionException;

    @Description(value="sets JMX Mbean's attribute")
    @MXAction(value="jmx-set", method="POST")
    @MXContentType
    public JmxSetQueryReply setJmx(@MXParam(name="server") String var1, @MXParam(name="pattern") String var2, @MXParam(name="attribute") String var3, @MXParam(name="value") String var4) throws ReflectionException;

    @Description(value="displays a JVM thread dump summary")
    @MXAction(value="thread-dump")
    @MXContentType
    public JsonQueryReply doThreadDump(@MXParam(name="server") String var1) throws ReflectionException;

    @Description(value="adds a Resin-Professional license to an installation")
    @MXAction(value="license-add", method="POST")
    @MXContentType
    public StringQueryReply addLicense(@MXParam(name="server") String var1, @MXParam(name="overwrite") boolean var2, @MXParam(name="to", required=true) String var3, @MXParam(name="restart") boolean var4, InputStream var5) throws ReflectionException;

    @Description(value="lists the most recent Resin server restart times")
    @MXAction(value="list-restarts", method="GET")
    @MXContentType
    public Date[] listRestarts(@MXParam(name="server") String var1, @MXParam(name="period", defaultValue="7D") String var2) throws ReflectionException;

    @Description(value="calls a method on a JMX MBean")
    @MXAction(value="jmx-call", method="POST")
    @MXContentType
    public JmxCallQueryReply callJmx(@MXParam(name="server") String var1, @MXParam(name="pattern") String var2, @MXParam(name="operation") String var3, @MXParam(name="operation-index") String var4, @MXParam(name="values") String var5) throws ReflectionException;

    @Description(value="starts a deployed application")
    @MXAction(value="web-app-start", method="POST")
    @MXContentType
    public DeployControllerState startWebApp(@MXParam(name="server") String var1, @MXParam(name="tag") String var2, @MXParam(name="context") String var3, @MXParam(name="stage", defaultValue="production") String var4, @MXParam(name="host", defaultValue="default") String var5, @MXParam(name="version") String var6) throws ReflectionException;

    @Description(value="stops a deployed application")
    @MXAction(value="web-app-stop", method="POST")
    @MXContentType
    public DeployControllerState stopWebApp(@MXParam(name="server") String var1, @MXParam(name="tag") String var2, @MXParam(name="context") String var3, @MXParam(name="stage", defaultValue="production") String var4, @MXParam(name="host", defaultValue="default") String var5, @MXParam(name="version") String var6) throws ReflectionException;

    @Description(value="restarts a deployed application")
    @MXAction(value="web-app-restart", method="POST")
    @MXContentType
    public DeployControllerState restartWebApp(@MXParam(name="server") String var1, @MXParam(name="tag") String var2, @MXParam(name="context") String var3, @MXParam(name="stage", defaultValue="production") String var4, @MXParam(name="host", defaultValue="default") String var5, @MXParam(name="version") String var6) throws ReflectionException;

    @Description(value="deploys an application")
    @MXAction(value="web-app-deploy", method="POST")
    @MXContentType
    public String webappDeploy(@MXParam(name="server") String var1, @MXParam(name="context", required=true) String var2, @MXParam(name="host", defaultValue="default") String var3, @MXParam(name="stage") String var4, @MXParam(name="version") String var5, @MXParam(name="message") String var6, InputStream var7) throws ReflectionException;

    @Description(value="copies a deployment to a new tag name")
    @MXAction(value="deploy-copy", method="POST")
    @MXContentType
    public String deployCopy(@MXParam(name="server") String var1, @MXParam(name="source-context") String var2, @MXParam(name="source-host", defaultValue="default") String var3, @MXParam(name="source-stage") String var4, @MXParam(name="source-version") String var5, @MXParam(name="target-context") String var6, @MXParam(name="target-host", defaultValue="default") String var7, @MXParam(name="target-stage") String var8, @MXParam(name="target-version") String var9, @MXParam(name="message") String var10) throws ReflectionException;

    @Description(value="lists deployed applications")
    @MXAction(value="deploy-list")
    @MXContentType
    public DeployTagResult[] deployList(@MXParam(name="server") String var1, @MXParam(name="pattern", defaultValue=".*") String var2) throws ReflectionException;

    @Description(value="undeploys an application")
    @MXAction(value="web-app-undeploy", method="POST")
    @MXContentType
    public String undeploy(@MXParam(name="server") String var1, @MXParam(name="context", required=true) String var2, @MXParam(name="host", defaultValue="default") String var3, @MXParam(name="stage") String var4, @MXParam(name="version") String var5, @MXParam(name="message") String var6) throws ReflectionException;

    @Description(value="adds an administration user and password")
    @MXContentType
    public AddUserQueryReply addUser(@MXParam(name="server") String var1, @MXParam(name="user", required=true) String var2, @MXParam(name="password") String var3, @MXParam(name="roles") String var4) throws ReflectionException;

    @Description(value="lists the administration user")
    @MXContentType
    public ListUsersQueryReply listUsers(@MXParam(name="server") String var1) throws ReflectionException;

    @Description(value="removes an administration user")
    @MXContentType
    public RemoveUserQueryReply removeUser(@MXParam(name="server") String var1, @MXParam(name="user") String var2) throws ReflectionException;

    @Description(value="Prints status of a server")
    @MXAction(value="status")
    @MXContentType
    public StringQueryReply getStatus(@MXParam(name="server") String var1) throws ReflectionException;

    @Description(value="Enables a server")
    @MXAction(value="enable", method="POST")
    public String enable(@MXParam(name="server") String var1) throws ReflectionException;

    @Description(value="Disables a server")
    @MXAction(value="disable", method="POST")
    public String disable(@MXParam(name="server") String var1) throws ReflectionException;

    @Description(value="Disables a server from accepting any new sessions")
    @MXAction(value="disable-soft", method="POST")
    public String disableSoft(@MXParam(name="server") String var1) throws ReflectionException;
}

