/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.make;

import com.caucho.loader.Environment;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.Dependency;
import java.util.concurrent.atomic.AtomicLong;

public abstract class CachedDependency
implements Dependency {
    private long _checkInterval;
    private AtomicLong _lastCheckTime = new AtomicLong();
    private boolean _isModified;

    public CachedDependency() {
        this.setCheckInterval(Environment.getDependencyCheckInterval());
    }

    public long getCheckInterval() {
        return this._checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this._checkInterval = Math.max(0L, checkInterval);
    }

    public final boolean isModified() {
        long lastCheckTime;
        long now = CurrentTime.getCurrentTime();
        if (now <= (lastCheckTime = this._lastCheckTime.get()) + this._checkInterval) {
            return this._isModified;
        }
        if (!this._lastCheckTime.compareAndSet(lastCheckTime, now)) {
            return this._isModified;
        }
        this._isModified = this.isModifiedImpl();
        return this._isModified;
    }

    public abstract boolean isModifiedImpl();
}

