/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class LoggerConfig {
    private static final L10N L = new L10N(LoggerConfig.class);
    private Logger _logger;
    private String _name;
    private Level _level = Level.INFO;
    private Boolean _useParentHandlers;
    private Filter _filter;
    private ArrayList<Handler> _handlerList = new ArrayList();
    private boolean _isSkipInit;

    public LoggerConfig() {
    }

    public LoggerConfig(boolean isSkipInit) {
        this();
        this._isSkipInit = isSkipInit;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this._useParentHandlers = new Boolean(useParentHandlers);
    }

    public void setLevel(String level) throws ConfigException {
        try {
            this._level = level == null || level.equals("") ? Level.INFO : Level.parse(level.toUpperCase());
        }
        catch (Exception e) {
            throw new ConfigException(L.l("'{0}' is an unknown log level.  Log levels are:\noff - disable logging\nsevere - severe errors only\nwarning - warnings\ninfo - information\nconfig - configuration\nfine - fine debugging\nfiner - finer debugging\nfinest - finest debugging\nall - all debugging", (Object)level), e);
        }
    }

    public void add(Handler handler) {
        this._handlerList.add(handler);
    }

    public void add(Filter filter) {
        this._filter = filter;
    }

    @PostConstruct
    public void init() {
        if (!this._isSkipInit) {
            this.initImpl();
        }
    }

    public void initImpl() {
        if (this._name == null) {
            throw new ConfigException(L.l("<logger> requires a 'name' attribute."));
        }
        this._logger = Logger.getLogger(this._name);
        if (this._level != null) {
            this._logger.setLevel(this._level);
        }
        if (this._useParentHandlers != null) {
            this._logger.setUseParentHandlers(this._useParentHandlers);
        }
        for (Handler handler : this._handlerList) {
            this._logger.addHandler(handler);
        }
        if (this._filter != null) {
            this._logger.setFilter(this._filter);
        }
    }
}

