/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;

public class JmsHandler
extends Handler {
    private static final Logger log = Logger.getLogger(JmsHandler.class.getName());
    private static final L10N L = new L10N(JmsHandler.class);
    private ConnectionFactory _factory;
    private Connection _conn;
    private Session _session;
    private ArrayList<Destination> _destinationList = new ArrayList();
    private ArrayList<BlockingQueue> _queueList = new ArrayList();

    public void setConnectionFactory(ConnectionFactory factory) {
        this._factory = factory;
    }

    public void addTarget(Destination target) {
        if (target instanceof BlockingQueue) {
            this._queueList.add((BlockingQueue)((Object)target));
        } else {
            this._destinationList.add(target);
        }
    }

    @PostConstruct
    public void init() throws ConfigException {
        try {
            if (this._destinationList.size() > 0 && this._factory == null) {
                throw new ConfigException(L.l("jms: log handler requires a connection-factory"));
            }
            if (this._destinationList.size() > 0) {
                this._conn = this._factory.createConnection();
                this._session = this._conn.createSession(false, 1);
            }
        }
        catch (JMSException e) {
            throw ConfigException.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        block9: {
            if (!this.isLoggable(record)) {
                return;
            }
            Filter filter = this.getFilter();
            if (filter != null && !filter.isLoggable(record)) {
                return;
            }
            try {
                Formatter formatter = this.getFormatter();
                String value = formatter != null ? formatter.format(record) : record.getMessage();
                for (BlockingQueue queue : this._queueList) {
                    queue.offer(value);
                }
                if (this._session == null) break block9;
                Session session = this._session;
                synchronized (session) {
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void flush() {
    }

    public void close() {
    }

    public String toString() {
        if (this._queueList.size() > 0) {
            return this.getClass().getSimpleName() + this._queueList;
        }
        return this.getClass().getSimpleName() + this._destinationList;
    }
}

