/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.ivy;

import com.caucho.config.Config;
import com.caucho.loader.ivy.IvyCache;
import com.caucho.loader.ivy.IvyDependency;
import com.caucho.loader.ivy.IvyModule;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyManager {
    private static final Logger log = Logger.getLogger(IvyManager.class.getName());
    private static final String SCHEMA = "com/caucho/loader/ivy/ivy.rnc";
    private ArrayList<IvyCache> _cacheList = new ArrayList();
    private Path _ivyFile;
    private HashMap<IvyModuleKey, String[]> _versionMap = new HashMap();
    private ArrayList<IvyModule> _moduleList = new ArrayList();
    private ArrayList<IvyDependency> _dependencyList = new ArrayList();
    private boolean _isModified;
    private ArrayList<Path> _jarList = new ArrayList();

    public IvyCache createCache() {
        IvyCache cache = new IvyCache(this);
        this._cacheList.add(cache);
        return cache;
    }

    void init() {
        if (this._cacheList.size() == 0) {
            IvyCache cache = new IvyCache(this);
            cache.init();
            this._cacheList.add(cache);
        }
    }

    public void setIvyFile(Path ivyFile) {
        this._ivyFile = ivyFile;
    }

    public IvyModule configureIvyFile(Path ivyFile) {
        IvyModule module = this.findIvyModule(ivyFile);
        if (module != null) {
            return module;
        }
        module = new IvyModule(this);
        module.setIvyPath(ivyFile);
        Config config = new Config();
        config.configure((Object)module, ivyFile, SCHEMA);
        this._moduleList.add(module);
        this._isModified = true;
        return module;
    }

    public IvyModule findIvyModule(Path ivyFile) {
        for (IvyModule module : this._moduleList) {
            if (!ivyFile.equals(module.getIvyPath())) continue;
            return module;
        }
        return null;
    }

    public ArrayList<Path> resolve() {
        while (this._isModified) {
            this._isModified = false;
            ArrayList<IvyModule> list = new ArrayList<IvyModule>(this._moduleList);
            for (IvyModule module : list) {
                for (IvyDependency depend : module.getDependencyList()) {
                    this.resolve(depend);
                }
            }
            ArrayList<IvyDependency> depList = new ArrayList<IvyDependency>(this._dependencyList);
            block3: for (IvyDependency dependency : depList) {
                for (IvyCache cache : this._cacheList) {
                    Path path = dependency.resolve(cache);
                    if (path == null || !path.canRead()) continue;
                    this.addJar(path);
                    continue block3;
                }
            }
        }
        return this._jarList;
    }

    void resolve(IvyDependency dependency) {
        dependency = this.mergeDependency(dependency);
        Object path = null;
        for (IvyCache cache : this._cacheList) {
            cache.resolveIvy(dependency);
        }
    }

    private IvyDependency mergeDependency(IvyDependency dependency) {
        for (int i = 0; i < this._dependencyList.size(); ++i) {
            IvyDependency dep = this._dependencyList.get(i);
            IvyDependency merge = dep.merge(dependency);
            if (merge == null) continue;
            this._dependencyList.set(i, merge);
            return merge;
        }
        IvyModuleKey key = new IvyModuleKey(dependency.getOrg(), dependency.getName());
        String[] versions = this.getVersions(dependency);
        dependency.setVersions(versions);
        this._isModified = true;
        this._dependencyList.add(dependency);
        return dependency;
    }

    private String[] getVersions(IvyDependency dependency) {
        ArrayList<String> versions = new ArrayList<String>();
        for (IvyCache cache : this._cacheList) {
            cache.resolveVersions(versions, dependency);
        }
        String[] versionArray = new String[versions.size()];
        versions.toArray(versionArray);
        return versionArray;
    }

    void addJar(Path path) {
        if (!this._jarList.contains(path)) {
            this._jarList.add(path);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static class IvyModuleKey {
        private String _org;
        private String _name;

        IvyModuleKey(String org, String name) {
            this._org = org;
            this._name = name;
        }

        public int hashCode() {
            return this._org.hashCode() * 6551 + this._name.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IvyModuleKey)) {
                return false;
            }
            IvyModuleKey key = (IvyModuleKey)o;
            return this._org.equals(key._org) && this._name.equals(key._name);
        }
    }
}

