/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.java.CompileClassNotFound;
import com.caucho.java.JavaCompilerUtil;
import com.caucho.loader.ClassEntry;
import com.caucho.loader.CompilingClassEntry;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Loader;
import com.caucho.make.AlwaysModified;
import com.caucho.make.Make;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.Crc64;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilingLoader
extends Loader
implements Make {
    private static final Logger log = Logger.getLogger(CompilingLoader.class.getName());
    private static final L10N L = new L10N(CompilingLoader.class);
    private static final char[] INNER_CLASS_SEPARATORS = new char[]{'$', '+', '-'};
    private String _classPath;
    private String _compiler;
    private String _sourceExt = ".java";
    private Path _sourceDir;
    private Path _classDir;
    private CodeSource _codeSource;
    private ArrayList<String> _args;
    private String _encoding;
    private boolean _requireSource;
    private HashSet<String> _excludedDirectories = new HashSet();
    private long _lastMakeTime;
    private boolean _isBatch = true;

    public CompilingLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public CompilingLoader(ClassLoader loader) {
        super(loader);
        this._excludedDirectories.add("CVS");
        this._excludedDirectories.add(".svn");
    }

    public CompilingLoader(ClassLoader loader, Path classDir) {
        this(loader, classDir, classDir, null, null);
    }

    public CompilingLoader(ClassLoader loader, Path classDir, Path sourceDir, String args, String encoding) {
        this(loader);
        if (classDir.getScheme().equals("http") || classDir.getScheme().equals("https")) {
            throw new ConfigException(L.l("compiling class loader can't be '{0}'.  Use compile=false.", (Object)classDir));
        }
        this._sourceDir = sourceDir;
        this._classDir = classDir;
        this._encoding = encoding;
    }

    public static DynamicClassLoader create(Path path) {
        DynamicClassLoader loader = new DynamicClassLoader(null);
        CompilingLoader compilingLoader = new CompilingLoader(loader, path);
        compilingLoader.init();
        loader.init();
        return loader;
    }

    public void setPath(Path path) {
        this._classDir = path;
        if (this._sourceDir == null) {
            this._sourceDir = path;
        }
    }

    public Path getPath() {
        return this._classDir;
    }

    public void setSource(Path path) {
        this._sourceDir = path;
    }

    public void setSourceExtension(String ext) throws ConfigException {
        if (!ext.startsWith(".")) {
            throw new ConfigException(L.l("source-extension '{0}' must begin with '.'", (Object)ext));
        }
        this._sourceExt = ext;
    }

    public void setCompiler(String compiler) throws ConfigException {
        this._compiler = compiler;
    }

    public Path getSource() {
        return this._sourceDir;
    }

    public void setArgs(String arg) {
        int i = 0;
        int len = arg.length();
        CharBuffer cb = new CharBuffer();
        while (i < len) {
            char ch;
            while (i < len && Character.isWhitespace(ch = arg.charAt(i))) {
                ++i;
            }
            if (len <= i) {
                return;
            }
            cb.clear();
            while (i < len && !Character.isWhitespace(ch = arg.charAt(i))) {
                cb.append(ch);
                ++i;
            }
            this.addArg(cb.toString());
        }
    }

    public void addArg(String arg) {
        if (this._args == null) {
            this._args = new ArrayList();
        }
        this._args.add(arg);
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void setRequireSource(boolean requireSource) {
        this._requireSource = requireSource;
    }

    public void setBatch(boolean isBatch) {
        this._isBatch = isBatch;
    }

    @Override
    public boolean isDirectoryLoader() {
        return true;
    }

    @Override
    @PostConstruct
    public void init() throws ConfigException {
        if (this._classDir == null) {
            throw new ConfigException(L.l("'path' is a required attribute of <compiling-loader>."));
        }
        String scheme = this._classDir.getScheme();
        if (scheme != null && !scheme.equals("memory") && !scheme.equals("error")) {
            try {
                this._classDir.mkdirs();
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
            try {
                this._codeSource = new CodeSource(new URL(this._classDir.getURL()), (Certificate[])null);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        super.init();
        this.getClassLoader().addURL(this._classDir);
    }

    public static DynamicClassLoader create(ClassLoader parent, Path classDir, Path sourceDir, String args, String encoding) {
        DynamicClassLoader loader = new DynamicClassLoader(parent);
        loader.addLoader(new CompilingLoader(loader, classDir, sourceDir, args, encoding));
        loader.init();
        return loader;
    }

    public String getClassPath() {
        if (this._classPath == null) {
            this._classPath = this.getClassLoader().getClassPath();
        }
        return this._classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void make() throws IOException, ClassNotFoundException {
        CompilingLoader compilingLoader = this;
        synchronized (compilingLoader) {
            if (CurrentTime.getCurrentTime() < this._lastMakeTime + 2000L) {
                return;
            }
            this.makeImpl();
            this._lastMakeTime = CurrentTime.getCurrentTime();
        }
    }

    private void makeImpl() throws IOException, ClassNotFoundException {
        if (this._sourceDir.isDirectory() && !this._classDir.isDirectory()) {
            this._classDir.mkdirs();
        }
        String sourcePath = this.prefixClassPath(this.getClassPath());
        ArrayList<String> files = new ArrayList<String>();
        this.findAllModifiedClasses("", this._sourceDir, this._classDir, sourcePath, files);
        if (files.size() == 0) {
            return;
        }
        if (this._isBatch) {
            String[] paths = files.toArray(new String[files.size()]);
            this.compileBatch(paths, true);
        } else {
            while (files.size() > 0) {
                String path = files.remove(0);
                String[] paths = new String[]{path};
                this.compileBatch(paths, true);
            }
        }
    }

    private void findAllModifiedClasses(String name, Path sourceDir, Path classDir, String sourcePath, ArrayList<String> sources) throws IOException, ClassNotFoundException {
        int i;
        String[] list;
        try {
            list = sourceDir.list();
        }
        catch (IOException e) {
            return;
        }
        for (i = 0; list != null && i < list.length; ++i) {
            int tail;
            String prefix;
            Path subClass;
            if (list[i].startsWith(".") || this._excludedDirectories.contains(list[i])) continue;
            Path subSource = sourceDir.lookup(list[i]);
            if (subSource.isDirectory()) {
                this.findAllModifiedClasses(name + list[i] + "/", subSource, classDir.lookup(list[i]), sourcePath, sources);
                continue;
            }
            if (!list[i].endsWith(this._sourceExt) || (subClass = classDir.lookup((prefix = list[i].substring(0, tail = list[i].length() - this._sourceExt.length())) + ".class")).getLastModified() >= subSource.getLastModified()) continue;
            sources.add(name + list[i]);
        }
        if (!this._requireSource) {
            return;
        }
        try {
            list = classDir.list();
        }
        catch (IOException e) {
            return;
        }
        for (i = 0; list != null && i < list.length; ++i) {
            String prefix;
            Path subSource;
            if (list[i].startsWith(".") || this._excludedDirectories.contains(list[i])) continue;
            Path subClass = classDir.lookup(list[i]);
            if (!list[i].endsWith(".class") || (subSource = sourceDir.lookup((prefix = list[i].substring(0, list[i].length() - 6)) + this._sourceExt)).exists()) continue;
            String tail = subSource.getTail();
            boolean doRemove = true;
            if (tail.indexOf(36) > 0) {
                String subTail = tail.substring(0, tail.indexOf(36)) + this._sourceExt;
                Path subJava = subSource.getParent().lookup(subTail);
                if (subJava.exists()) {
                    doRemove = false;
                }
            }
            if (!doRemove) continue;
            log.finer(L.l("removing obsolete class '{0}'.", (Object)subClass.getPath()));
            subClass.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ClassEntry getClassEntry(String name, String pathName) throws ClassNotFoundException {
        Path classFile = this._classDir.lookup(pathName);
        String javaName = name.replace('.', '/') + this._sourceExt;
        Path javaFile = this._sourceDir.lookup(javaName);
        for (int i = 0; i < INNER_CLASS_SEPARATORS.length; ++i) {
            String subName;
            String subJavaName;
            Path subJava;
            char sep = INNER_CLASS_SEPARATORS[i];
            if (name.indexOf(sep) <= 0 || !(subJava = this._sourceDir.lookup(subJavaName = (subName = name.substring(0, name.indexOf(sep))).replace('.', '/') + this._sourceExt)).exists()) continue;
            javaFile = subJava;
        }
        CompilingLoader compilingLoader = this;
        synchronized (compilingLoader) {
            boolean doRemove;
            if (this._requireSource && !javaFile.exists() && (doRemove = true)) {
                log.finer(L.l("removing obsolete class `{0}'.", (Object)classFile.getPath()));
                try {
                    classFile.remove();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                return null;
            }
            if (!classFile.canRead() && !javaFile.canRead()) {
                return null;
            }
            return new CompilingClassEntry(this, this.getClassLoader(), name, javaFile, classFile, this.getCodeSource(classFile));
        }
    }

    @Override
    protected CodeSource getCodeSource(Path path) {
        return this._codeSource;
    }

    boolean checkSource(Path sourceDir, String javaName) {
        try {
            while (javaName != null && !javaName.equals("")) {
                int i;
                String head;
                int p = javaName.indexOf(47);
                if (p >= 0) {
                    head = javaName.substring(0, p);
                    javaName = javaName.substring(p + 1);
                } else {
                    head = javaName;
                    javaName = null;
                }
                String[] names = sourceDir.list();
                for (i = 0; i < names.length && !names[i].equals(head); ++i) {
                }
                if (i == names.length) {
                    return false;
                }
                sourceDir = sourceDir.lookup(head);
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
        return true;
    }

    void compileClass(Path javaSource, Path javaClass, String sourcePath, boolean isMake) throws ClassNotFoundException {
        try {
            String source;
            JavaCompilerUtil compiler = JavaCompilerUtil.create(this.getClassLoader());
            compiler.setClassDir(this._classDir);
            compiler.setSourceDir(this._sourceDir);
            if (this._encoding != null) {
                compiler.setEncoding(this._encoding);
            }
            compiler.setArgs(this._args);
            compiler.setCompileParent(!isMake);
            compiler.setSourceExtension(this._sourceExt);
            if (this._compiler != null) {
                compiler.setCompiler(this._compiler);
            }
            String prefix = this._sourceDir.getPath();
            String full = javaSource.getPath();
            if (full.startsWith(prefix)) {
                source = full.substring(prefix.length());
                if (source.startsWith("/")) {
                    source = source.substring(1);
                }
            } else {
                source = javaSource.getPath();
            }
            compiler.compileIfModified(source, null);
        }
        catch (Exception e) {
            this.getClassLoader().addDependency(new Depend(javaSource));
            log.log(Level.FINEST, e.toString(), e);
            throw new CompileClassNotFound(e);
        }
    }

    void compileBatch(String[] files, boolean isMake) throws ClassNotFoundException {
        try {
            JavaCompilerUtil compiler = JavaCompilerUtil.create(this.getClassLoader());
            compiler.setClassDir(this._classDir);
            compiler.setSourceDir(this._sourceDir);
            if (this._encoding != null) {
                compiler.setEncoding(this._encoding);
            }
            compiler.setArgs(this._args);
            compiler.setCompileParent(!isMake);
            compiler.setSourceExtension(this._sourceExt);
            if (this._compiler != null) {
                compiler.setCompiler(this._compiler);
            }
            compiler.compileBatch(files);
        }
        catch (Exception e) {
            this.getClassLoader().addDependency(AlwaysModified.create());
            throw new CompileClassNotFound(e);
        }
    }

    @Override
    public Path getPath(String name) {
        Path path = this._classDir.lookup(name);
        if (path != null && path.exists()) {
            return path;
        }
        path = this._sourceDir.lookup(name);
        if (path != null && path.exists()) {
            return path;
        }
        return null;
    }

    @Override
    protected long getHashCrc(long crc64) {
        crc64 = Crc64.generate(this._classDir.getURL());
        return crc64;
    }

    @Override
    protected void buildClassPath(ArrayList<String> pathList) {
        if (!this._classDir.getScheme().equals("file")) {
            return;
        }
        try {
            String path;
            if (!this._classDir.isDirectory() && this._sourceDir.isDirectory()) {
                try {
                    this._classDir.mkdirs();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this._classDir.isDirectory() && !pathList.contains(path = this._classDir.getNativePath())) {
                pathList.add(path);
            }
            if (!this._classDir.equals(this._sourceDir) && !pathList.contains(path = this._sourceDir.getNativePath())) {
                pathList.add(path);
            }
        }
        catch (AccessControlException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    protected String prefixClassPath(String tail) {
        CharBuffer cb = new CharBuffer();
        if (!this._classDir.isDirectory() && this._sourceDir.isDirectory()) {
            try {
                this._classDir.mkdirs();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this._classDir.isDirectory()) {
            if (cb.length() > 0) {
                cb.append(CauchoSystem.getPathSeparatorChar());
            }
            cb.append(this._classDir.getNativePath());
        }
        if (!this._classDir.equals(this._sourceDir)) {
            if (cb.length() > 0) {
                cb.append(CauchoSystem.getPathSeparatorChar());
            }
            cb.append(this._sourceDir.getNativePath());
        }
        if (cb.length() > 0) {
            cb.append(CauchoSystem.getPathSeparatorChar());
        }
        cb.append(tail);
        return cb.close();
    }

    public String toString() {
        if (this._classDir == null) {
            return "CompilingLoader[]";
        }
        if (this._classDir.equals(this._sourceDir)) {
            return "CompilingLoader[src:" + this._sourceDir + "]";
        }
        return "CompilingLoader[src:" + this._sourceDir + ",class:" + this._classDir + "]";
    }
}

