/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.junit;

import com.caucho.junit.ResinConfiguration;
import com.caucho.resin.HttpEmbed;
import com.caucho.resin.ResinEmbed;
import com.caucho.resin.WebAppEmbed;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResinRunner
extends BlockJUnit4ClassRunner {
    private int _httpPort = 8086;
    private String _webApplicationContext = "/";
    private String _webApplicationRoot = ".";
    private String _resinXmlPath = null;
    private ResinEmbed _resinEmbeddedContainer;

    public ResinRunner(Class<?> testClass) throws Throwable {
        super(testClass);
        ResinConfiguration resinConfiguration = testClass.getAnnotation(ResinConfiguration.class);
        this._httpPort = resinConfiguration.httpPort();
        this._webApplicationContext = resinConfiguration.webApplicationContext();
        this._webApplicationRoot = resinConfiguration.webApplicationRoot();
        this._resinXmlPath = resinConfiguration.resinXml();
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        ResinEmbed resinEmbeddedContainer = this.getResinEmbeddedContainer();
        super.runChild(method, notifier);
    }

    protected ResinEmbed getResinEmbeddedContainer() {
        if (this._resinEmbeddedContainer == null) {
            this._resinEmbeddedContainer = this._resinXmlPath == null ? new ResinEmbed() : new ResinEmbed(this._resinXmlPath);
            this._resinEmbeddedContainer.addScanRoot();
            this._resinEmbeddedContainer.addPort(new HttpEmbed(this._httpPort));
            this._resinEmbeddedContainer.addWebApp(new WebAppEmbed(this._webApplicationContext, this._webApplicationRoot));
            this._resinEmbeddedContainer.start();
        }
        return this._resinEmbeddedContainer;
    }
}

