/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.BodyContentImpl;
import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.el.CoreSetTag;
import com.caucho.util.L10N;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.el.ELContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class FormatNumberTag
extends BodyTagSupport {
    private static L10N L = new L10N(FormatNumberTag.class);
    private Expr _valueExpr;
    private Expr _typeExpr;
    private Expr _patternExpr;
    private Expr _currencyCodeExpr;
    private Expr _currencySymbolExpr;
    private Expr _groupingUsedExpr;
    private Expr _maxIntegerDigitsExpr;
    private Expr _minIntegerDigitsExpr;
    private Expr _maxFractionDigitsExpr;
    private Expr _minFractionDigitsExpr;
    private String _var;
    private String _scope;

    public void setValue(Expr value) {
        this._valueExpr = value;
    }

    public void setType(Expr type) {
        this._typeExpr = type;
    }

    public void setPattern(Expr pattern) {
        this._patternExpr = pattern;
    }

    public void setCurrencyCode(Expr currencyCode) {
        this._currencyCodeExpr = currencyCode;
    }

    public void setCurrencySymbol(Expr currencySymbol) {
        this._currencySymbolExpr = currencySymbol;
    }

    public void setGroupingUsed(Expr groupingUsed) {
        this._groupingUsedExpr = groupingUsed;
    }

    public void setMinIntegerDigits(Expr minIntegerDigits) {
        this._minIntegerDigitsExpr = minIntegerDigits;
    }

    public void setMaxIntegerDigits(Expr maxIntegerDigits) {
        this._maxIntegerDigitsExpr = maxIntegerDigits;
    }

    public void setMinFractionDigits(Expr minFractionDigits) {
        this._minFractionDigitsExpr = minFractionDigits;
    }

    public void setMaxFractionDigits(Expr maxFractionDigits) {
        this._maxFractionDigitsExpr = maxFractionDigits;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public int doEndTag() throws JspException {
        try {
            NumberFormat format;
            String value;
            PageContextImpl pageContext = (PageContextImpl)this.pageContext;
            ELContext env = pageContext.getELContext();
            JspWriter out = pageContext.getOut();
            BodyContentImpl body = (BodyContentImpl)this.getBodyContent();
            double number = this._valueExpr != null ? this._valueExpr.evalDouble(env) : (body != null ? (!(value = body.getTrimString()).equals("") ? Double.parseDouble(value) : 0.0) : 0.0);
            if (Double.isNaN(number)) {
                number = 0.0;
            }
            String value2 = (format = this.getFormat()) != null ? format.format(number) : String.valueOf(number);
            if (this._var == null) {
                out.print(value2);
            } else {
                CoreSetTag.setValue(pageContext, this._var, this._scope, value2);
            }
        }
        catch (Exception e) {
            throw new JspException(e);
        }
        return 6;
    }

    protected NumberFormat getFormat() throws JspException {
        try {
            PageContextImpl pageContext = (PageContextImpl)this.pageContext;
            ELContext env = pageContext.getELContext();
            NumberFormat format = null;
            Locale locale = pageContext.getLocale();
            String type = null;
            if (this._typeExpr != null) {
                type = this._typeExpr.evalString(env);
            }
            if (type == null || type.equals("") || type.equals("number")) {
                format = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance();
                DecimalFormat decimalFormat = (DecimalFormat)format;
                if (this._patternExpr != null) {
                    decimalFormat.applyPattern(this._patternExpr.evalString(env));
                }
            } else if (type.equals("percent")) {
                format = locale != null ? NumberFormat.getPercentInstance(locale) : NumberFormat.getPercentInstance();
            } else if (type.equals("currency")) {
                format = locale != null ? NumberFormat.getCurrencyInstance(locale) : NumberFormat.getCurrencyInstance();
                if ((this._currencyCodeExpr != null || this._currencySymbolExpr != null) && format instanceof DecimalFormat) {
                    DecimalFormat dFormat = (DecimalFormat)format;
                    DecimalFormatSymbols dSymbols = dFormat.getDecimalFormatSymbols();
                    if (this._currencyCodeExpr != null && dSymbols != null) {
                        dSymbols.setInternationalCurrencySymbol(this._currencyCodeExpr.evalString(env));
                    }
                    if (this._currencySymbolExpr != null && dSymbols != null) {
                        dSymbols.setCurrencySymbol(this._currencySymbolExpr.evalString(env));
                    }
                    dFormat.setDecimalFormatSymbols(dSymbols);
                }
            } else {
                throw new JspException(L.l("unknown formatNumber type `{0}'", (Object)type));
            }
            if (this._groupingUsedExpr != null) {
                format.setGroupingUsed(this._groupingUsedExpr.evalBoolean(env));
            }
            if (this._minIntegerDigitsExpr != null) {
                format.setMinimumIntegerDigits((int)this._minIntegerDigitsExpr.evalLong(env));
            }
            if (this._maxIntegerDigitsExpr != null) {
                format.setMaximumIntegerDigits((int)this._maxIntegerDigitsExpr.evalLong(env));
            }
            if (this._minFractionDigitsExpr != null) {
                format.setMinimumFractionDigits((int)this._minFractionDigitsExpr.evalLong(env));
            }
            if (this._maxFractionDigitsExpr != null) {
                format.setMaximumFractionDigits((int)this._maxFractionDigitsExpr.evalLong(env));
            }
            return format;
        }
        catch (Exception e) {
            throw new JspException(e);
        }
    }
}

