/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.jsp.JspParseException;
import com.caucho.jsp.java.JspContainerNode;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.util.BeanUtil;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QName;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JspSetProperty
extends JspContainerNode {
    private static final Logger log = Logger.getLogger(JspSetProperty.class.getName());
    private static final QName NAME = new QName("name");
    private static final QName PROPERTY = new QName("property");
    private static final QName PARAM = new QName("param");
    private static final QName VALUE = new QName("value");
    private String _name;
    private String _property;
    private String _param;

    public void addAttribute(QName name, String value) throws JspParseException {
        if (NAME.equals(name)) {
            this._name = value;
        } else if (PROPERTY.equals(name)) {
            this._property = value;
        } else if (PARAM.equals(name)) {
            this._param = value;
        } else if (VALUE.equals(name)) {
            super.addAttribute(name, value);
        } else {
            throw this.error(L.l("`{0}' is an invalid attribute in <jsp:setProperty>", (Object)name.getName()));
        }
    }

    public void printXml(WriteStream os) throws IOException {
        os.print("<jsp:setProperty name=\"" + this._name + "\"");
        os.print(" property=\"" + this._property + "\"/>");
    }

    public void generate(JspJavaWriter out) throws Exception {
        if (this._name == null) {
            throw this.error(L.l("<jsp:setProperty> expects a `name' attribute."));
        }
        if (this._property == null) {
            throw this.error(L.l("<jsp:setProperty> expects a `property' attribute."));
        }
        Object value = this.getAttribute("value");
        if (value == null) {
            this.generateSetParamProperty(out, this._name, this._property, this._param);
            return;
        }
        Class<?> cl = this._gen.getClass(this._name);
        if (cl == null) {
            throw this.error(L.l("`{0}' is an unknown bean in <jsp:setProperty>.  All beans must be declared in a <jsp:useBean>.", (Object)this._name));
        }
        PropertyDescriptor[] pds = Introspector.getBeanInfo(cl).getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            if (!pds[i].getName().equals(this._property) || pds[i].getWriteMethod() == null || pds[i].getPropertyEditorClass() == null) continue;
            this.generateSetParameter(out, this._name, (String)value, pds[i].getWriteMethod(), pds[i].getPropertyEditorClass());
            return;
        }
        Method setMethod = BeanUtil.getSetMethod(cl, this._property);
        if (setMethod == null) {
            throw this.error(L.l("bean `{0}' has no set property `{1}'", (Object)this._name, (Object)this._property));
        }
        this.generateSetParameter(out, this._name, value, setMethod, true, "pageContext", false, false, null);
    }

    private void generateSetParamProperty(JspJavaWriter out, String name, String property, String param) throws Exception {
        boolean foundProp = property.equals("*");
        Class<?> cl = this._gen.getClass(name);
        if (cl == null) {
            throw this.error(L.l("{0} unknown variable `{1}'", (Object)"jsp:setProperty", (Object)name));
        }
        out.println("{");
        out.pushDepth();
        out.println("java.lang.String _jspParam;");
        try {
            Class<?> beanClass = cl;
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            Method[] methods = beanClass.getMethods();
            boolean hasParams = false;
            for (int i = 0; i < methods.length; ++i) {
                PropertyEditor editor;
                Class<?>[] params;
                String propName;
                Method setMethod = methods[i];
                String methodName = setMethod.getName();
                if (!methodName.startsWith("set") || (propName = this.methodNameToPropertyName(info, methodName)) == null || !property.equals("*") && !propName.equals(property) || (params = setMethod.getParameterTypes()).length != 1 || this.hasBetterMethod(methods, setMethod)) continue;
                Class<?> paramType = params[0];
                String type = paramType.getName();
                String tail = null;
                boolean isArray = false;
                String p = param;
                if (p == null) {
                    p = propName;
                }
                if (!paramType.isArray()) {
                    tail = this.stringToValue(paramType, "_jspParam");
                }
                if (tail == null && paramType.isArray()) {
                    Class<?> compType = paramType.getComponentType();
                    if (!hasParams) {
                        out.println("java.lang.String []_jspParams;");
                    }
                    hasParams = true;
                    out.println("_jspParams = request.getParameterValues(\"" + p + "\");");
                    isArray = true;
                    if (String.class.equals(compType) || Object.class.equals(compType)) {
                        foundProp = true;
                        out.println("if (_jspParams != null)");
                        out.println("  " + name + "." + methodName + "(_jspParams);");
                    } else {
                        tail = this.stringToValue(compType, "_jspParams[_jsp_i]");
                        if (tail != null) {
                            foundProp = true;
                            out.println("if (_jspParams != null) {");
                            out.println("  " + compType.getName() + " []_jsp_values = " + " new " + compType.getName() + "[_jspParams.length];");
                            out.println("  for (int _jsp_i = _jspParams.length - 1; _jsp_i >= 0; _jsp_i--)");
                            out.println("    _jsp_values[_jsp_i] = " + tail + ";");
                            out.println("  " + name + "." + methodName + "(_jsp_values);");
                            out.println("}");
                        } else {
                            editor = PropertyEditorManager.findEditor(paramType);
                            if (editor != null) {
                                foundProp = true;
                                out.println("if (_jspParams != null) {");
                                out.println("  " + compType.getName() + " []_jsp_values = " + " new " + compType.getName() + "[_jspParams.length];");
                                out.println("   java.beans.PropertyEditor _editor =   java.beans.PropertyEditorManager.findEditor(" + compType.getName() + ".class);");
                                out.println("  for (int _jsp_i = _jspParams.length - 1; _jsp_i >= 0; _jsp_i--) {");
                                out.println("    _editor.setAsText(_jspParams[_jsp_i]);");
                                out.println("    _jsp_values[_jsp_i] = (" + compType.getName() + ") _editor.getValue();");
                                out.println("  " + name + "." + methodName + "(_jsp_values);");
                                out.println("}");
                            }
                        }
                    }
                }
                if (isArray) continue;
                if (tail != null) {
                    out.println("_jspParam = request.getParameter(\"" + p + "\");");
                    out.println("if (_jspParam != null && ! _jspParam.equals(\"\"))");
                    out.println("  " + name + "." + methodName + "(" + tail + ");");
                    foundProp = true;
                    continue;
                }
                editor = PropertyEditorManager.findEditor(paramType);
                if (editor == null) continue;
                out.println("_jspParam = request.getParameter(\"" + p + "\");");
                out.println("if (_jspParam != null && ! _jspParam.equals(\"\")) {");
                out.println("   java.beans.PropertyEditor _editor =   java.beans.PropertyEditorManager.findEditor(" + paramType.getName() + ".class);");
                out.println("  _editor.setAsText(_jspParam);");
                out.println("  " + name + "." + methodName + "((" + paramType.getName() + ") _editor.getValue());");
                out.println("}");
                foundProp = true;
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            throw this.error(L.l("{0} can't find class `{1}'", (Object)"jsp:setProperty", (Object)name));
        }
        if (!foundProp) {
            throw this.error(L.l("bean `{0}' has no property named `{1}'", (Object)name, (Object)property));
        }
        out.popDepth();
        out.println("}");
    }

    private boolean hasBetterMethod(Method[] methods, Method setMethod) {
        Class<?>[] setParam = setMethod.getParameterTypes();
        if (setParam[0].equals(String.class)) {
            return false;
        }
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] param;
            Method method = methods[i];
            if (method == setMethod || !method.getName().equals(setMethod.getName()) || (param = method.getParameterTypes()).length != 1 || !param[0].equals(String.class)) continue;
            return true;
        }
        return false;
    }

    private String methodNameToPropertyName(BeanInfo info, String methodName) {
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            Method setter = pds[i].getWriteMethod();
            if (setter == null || !setter.getName().equals(methodName)) continue;
            return pds[i].getName();
        }
        return BeanUtil.methodNameToPropertyName(methodName);
    }
}

