/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.java.JavaCompilerUtil;
import com.caucho.java.LineMap;
import com.caucho.jsp.JspManager;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.Page;
import com.caucho.jsp.QJspException;
import com.caucho.jsp.XslManager;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.RequestAdapter;
import com.caucho.server.http.ResponseAdapter;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.RegistryException;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoDocument;
import com.caucho.xml.Html;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlParser;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.XPath;
import com.caucho.xpath.XPathException;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.TransformerImpl;
import com.caucho.xsl.XslParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.ProcessingInstruction;

class XtpPage
extends Page {
    private static final Logger log = Logger.getLogger(XtpPage.class.getName());
    private boolean _strictXml;
    private boolean _toLower = true;
    private boolean _entitiesAsText = false;
    private Path _sourcePath;
    private Path _pwd;
    private String _uri;
    private String _className;
    private String _errorPage;
    private WebApp _webApp;
    private XslManager _xslManager;
    private Page _page;
    private HashMap<String, SoftReference<Page>> _varyMap;
    private ArrayList<String> _paramNames;
    private JspManager _jspManager;
    private final Semaphore _compileSemaphore = new Semaphore(1, false);

    XtpPage(Path path, String uri, String className, WebApp app, XslManager xslManager, boolean strictXml) throws ServletException, RegistryException {
        this._sourcePath = path;
        this._sourcePath.setUserPath(uri);
        this._pwd = this._sourcePath.getParent();
        this._className = className;
        this._webApp = app;
        this._strictXml = strictXml;
        this._xslManager = xslManager;
        this._uri = uri;
        ServletConfigImpl config = new ServletConfigImpl();
        config.setServletContext(this._webApp);
        this.init(config);
    }

    void setManager(JspManager manager) {
        this._jspManager = manager;
    }

    void setHtmlToLower(boolean toLower) {
        this._toLower = toLower;
    }

    void setEntitiesAsText(boolean entitiesAsText) {
        this._entitiesAsText = entitiesAsText;
    }

    public boolean _caucho_isModified() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        CauchoResponse res;
        CauchoRequest req = request instanceof CauchoRequest ? (CauchoRequest)request : RequestAdapter.create((HttpServletRequest)request, this._webApp);
        ResponseAdapter resAdapt = null;
        if (response instanceof CauchoResponse) {
            res = (CauchoResponse)response;
        } else {
            resAdapt = ResponseAdapter.create((HttpServletResponse)response);
            res = resAdapt;
        }
        try {
            try {
                this.service(req, res);
            }
            catch (InterruptedException e) {
                log.log(Level.FINE, e.toString(), e);
                log.warning("XTP: interrupted for " + req.getPageURI());
                res.sendError(503, "Server busy: XTP generation delayed");
                Object var8_7 = null;
                if (resAdapt == null) return;
                resAdapt.close();
                return;
            }
            Object var8_6 = null;
            if (resAdapt == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (resAdapt == null) throw throwable;
            resAdapt.close();
            throw throwable;
        }
        resAdapt.close();
    }

    public void service(CauchoRequest req, CauchoResponse res) throws IOException, ServletException, InterruptedException {
        Page page = this.getPage(req, res);
        if (page != null) {
            page.pageservice(req, res);
        } else {
            log.warning("XTP: server busy on " + req.getPageURI());
            res.setHeader("Retry-After", "15");
            res.sendError(503, "Server busy: XTP generation delayed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page getPage(CauchoRequest req, CauchoResponse res) throws IOException, ServletException, InterruptedException {
        Object ss = null;
        String varyName = null;
        Page page = this._page;
        Page deadPage = null;
        if (page == null && this._varyMap != null && (varyName = this.generateVaryName(req)) != null) {
            SoftReference<Page> ref = this._varyMap.get(varyName);
            Page page2 = page = ref != null ? ref.get() : null;
        }
        if (page != null && !page._caucho_isModified()) {
            return page;
        }
        deadPage = page;
        page = null;
        long timeout = deadPage == null ? 30L : 5L;
        Thread.interrupted();
        if (this._compileSemaphore.tryAcquire(timeout, TimeUnit.SECONDS)) {
            try {
                varyName = this.generateVaryName(req);
                page = this.getPrecompiledPage(req, varyName);
                if (page == null) {
                    CauchoDocument doc;
                    try {
                        doc = this.parseXtp();
                    }
                    catch (FileNotFoundException e) {
                        res.sendError(404);
                        throw e;
                    }
                    Templates stylesheet = this.compileStylesheet(req, doc);
                    varyName = this.generateVaryName(req);
                    page = this.getPrecompiledPage(req, varyName);
                    if (page == null) {
                        page = this.compileJspPage(req, res, doc, stylesheet, varyName);
                    }
                }
                if (page != null) {
                    ServletConfigImpl config = new ServletConfigImpl();
                    config.setServletContext(this._webApp);
                    page.init(config);
                    if (varyName != null && this._varyMap == null) {
                        this._varyMap = new HashMap(8);
                    }
                    if (varyName != null) {
                        this._varyMap.put(varyName, new SoftReference<Page>(page));
                    } else {
                        this._page = page;
                    }
                } else if (deadPage != null) {
                    this._page = null;
                    if (varyName != null && this._varyMap != null) {
                        this._varyMap.remove(varyName);
                    }
                }
                Object var12_12 = null;
                this._compileSemaphore.release();
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                this._compileSemaphore.release();
                throw throwable;
            }
        }
        log.warning("XTP: semaphore timed out on " + req.getPageURI());
        if (page != null) {
            return page;
        }
        return deadPage;
    }

    private Page getPrecompiledPage(CauchoRequest req, String varyName) throws IOException, ServletException {
        Page page = null;
        String className = this.getClassName(varyName);
        try {
            page = this._jspManager.preload(className, this._webApp.getClassLoader(), this._webApp.getRootDirectory(), null);
            if (page != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("XTP using precompiled page " + className);
                }
                return page;
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return null;
    }

    private CauchoDocument parseXtp() throws IOException, ServletException {
        ReadStream is = this._sourcePath.openRead();
        try {
            XmlParser parser;
            if (this._strictXml) {
                parser = new Xml();
                parser.setEntitiesAsText(this._entitiesAsText);
            } else {
                parser = new Html();
                parser.setAutodetectXml(true);
                parser.setEntitiesAsText(true);
                parser.setToLower(this._toLower);
            }
            parser.setResinInclude(true);
            parser.setJsp(true);
            CauchoDocument cauchoDocument = (CauchoDocument)parser.parseDocument(is);
            Object var5_6 = null;
            is.close();
            return cauchoDocument;
        }
        catch (Exception e) {
            try {
                JspParseException jspE = JspParseException.create(e);
                jspE.setErrorPage(this._errorPage);
                throw jspE;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                is.close();
                throw throwable;
            }
        }
    }

    private Templates compileStylesheet(CauchoRequest req, CauchoDocument doc) throws IOException, ServletException {
        String ssName = (String)req.getAttribute("caucho.xsl.stylesheet");
        Templates stylesheet = null;
        try {
            if (ssName == null) {
                ssName = this.getStylesheetHref(doc, null);
            }
            stylesheet = this._xslManager.get(ssName, req);
        }
        catch (XslParseException e) {
            JspParseException jspE = e.getException() != null ? new JspParseException(e.getException()) : new JspParseException(e);
            jspE.setErrorPage(this._errorPage);
            throw jspE;
        }
        catch (Exception e) {
            JspParseException jspE = new JspParseException(e);
            jspE.setErrorPage(this._errorPage);
            throw jspE;
        }
        ArrayList params = null;
        if (stylesheet instanceof StylesheetImpl) {
            StylesheetImpl ss = (StylesheetImpl)stylesheet;
            params = (ArrayList)ss.getProperty("caucho.global.param");
        }
        for (int i = 0; params != null && i < params.size(); ++i) {
            String param = (String)params.get(i);
            if (this._paramNames == null) {
                this._paramNames = new ArrayList();
            }
            if (param.equals("xtp:context_path") || param.equals("xtp:servlet_path") || this._paramNames.contains(param)) continue;
            this._paramNames.add(param);
        }
        return stylesheet;
    }

    private Page compileJspPage(CauchoRequest req, CauchoResponse res, CauchoDocument doc, Templates stylesheet, String varyName) throws IOException, ServletException {
        varyName = this.generateVaryName(req);
        String className = this.getClassName(varyName);
        try {
            return this.getJspPage(doc, stylesheet, req, res, className);
        }
        catch (TransformerConfigurationException e) {
            throw new ServletException(e);
        }
        catch (JspException e) {
            throw new ServletException(e);
        }
    }

    private String getClassName(String varyName) {
        if (varyName == null) {
            return this._className;
        }
        return this._className + JavaCompilerUtil.mangleName("?" + varyName);
    }

    private String generateVaryName(CauchoRequest req) {
        CharBuffer cb = CharBuffer.allocate();
        String ss = (String)req.getAttribute("caucho.xsl.stylesheet");
        if (ss == null && (this._paramNames == null || this._paramNames.size() == 0)) {
            return null;
        }
        if (ss != null) {
            cb.append("ss.");
            cb.append(ss);
        }
        for (int i = 0; this._paramNames != null && i < this._paramNames.size(); ++i) {
            String name = this._paramNames.get(i);
            String value = name.equals("xtp:path_info") ? req.getPathInfo() : req.getParameter(name);
            cb.append(".");
            cb.append(name);
            if (value == null) continue;
            cb.append(".");
            cb.append(value);
        }
        if (cb.length() == 0) {
            return null;
        }
        if (cb.length() < 64) {
            return cb.close();
        }
        long hash = 37L;
        for (int i = 0; i < cb.length(); ++i) {
            hash = 65521L * hash + (long)cb.charAt(i);
        }
        cb.setLength(32);
        Base64.encode(cb, hash);
        return cb.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page getJspPage(CauchoDocument doc, Templates stylesheet, CauchoRequest req, CauchoResponse res, String className) throws IOException, ServletException, JspException, TransformerConfigurationException {
        String pathInfo;
        String servletPath;
        Path workDir = this._jspManager.getClassDir();
        String fullClassName = className;
        Path path = workDir.lookup(fullClassName.replace('.', '/') + ".jsp");
        path.getParent().mkdirs();
        Properties output = stylesheet.getOutputProperties();
        String encoding = (String)output.get("encoding");
        String mimeType = (String)output.get("media-type");
        String method = (String)output.get("method");
        if (method != null && encoding == null && method.equals("xml")) {
            encoding = "UTF-8";
        }
        Transformer transformer = stylesheet.newTransformer();
        for (int i = 0; this._paramNames != null && i < this._paramNames.size(); ++i) {
            String param = this._paramNames.get(i);
            transformer.setParameter(param, req.getParameter(param));
        }
        String contextPath = req.getContextPath();
        if (contextPath != null && !contextPath.equals("")) {
            transformer.setParameter("xtp:context_path", contextPath);
        }
        if ((servletPath = req.getServletPath()) != null && !servletPath.equals("")) {
            transformer.setParameter("xtp:servlet_path", servletPath);
        }
        if ((pathInfo = req.getPathInfo()) != null && !pathInfo.equals("")) {
            transformer.setParameter("xtp:path_info", pathInfo);
        }
        transformer.setOutputProperty("caucho.jsp", "true");
        LineMap lineMap = null;
        WriteStream os = path.openWrite();
        try {
            if (encoding != null) {
                os.setEncoding(encoding);
                if (mimeType == null) {
                    mimeType = "text/html";
                }
                os.print("<%@ page contentType=\"" + mimeType + "; charset=" + encoding + "\" %>");
            } else if (mimeType != null) {
                os.print("<%@ page contentType=\"" + mimeType + "\" %>");
            }
            lineMap = this.writeJspDoc(os, doc, transformer, req, res);
            Object var20_20 = null;
        }
        catch (Throwable throwable) {
            Object var20_21 = null;
            os.close();
            throw throwable;
        }
        os.close();
        StylesheetImpl ss = null;
        if (stylesheet instanceof StylesheetImpl) {
            ss = (StylesheetImpl)stylesheet;
        }
        try {
            path.setUserPath(this._sourcePath.getPath());
            boolean cacheable = true;
            ArrayList<PersistentDependency> depends = new ArrayList<PersistentDependency>();
            ArrayList styleDepends = null;
            if (ss != null) {
                styleDepends = (ArrayList)ss.getProperty("caucho.depends");
            }
            for (int i = 0; styleDepends != null && i < styleDepends.size(); ++i) {
                Depend depend = (Depend)styleDepends.get(i);
                Depend jspDepend = new Depend(depend.getPath(), depend.getLastModified(), depend.getLength());
                jspDepend.setRequireSource(true);
                if (depends.contains(jspDepend)) continue;
                depends.add(jspDepend);
            }
            ArrayList docDepends = (ArrayList)doc.getProperty("caucho.depends");
            for (int i = 0; docDepends != null && i < docDepends.size(); ++i) {
                Path depend = (Path)docDepends.get(i);
                Depend jspDepend = new Depend(depend);
                if (depends.contains(jspDepend)) continue;
                depends.add(jspDepend);
            }
            ArrayList cacheDepends = null;
            TransformerImpl xform = null;
            if (transformer instanceof TransformerImpl) {
                xform = (TransformerImpl)transformer;
            }
            if (xform != null) {
                cacheDepends = (ArrayList)xform.getProperty("caucho.cache.depends");
            }
            for (int i = 0; cacheDepends != null && i < cacheDepends.size(); ++i) {
                Path depend = (Path)cacheDepends.get(i);
                Depend jspDepend = new Depend(depend);
                if (depends.contains(jspDepend)) continue;
                depends.add(jspDepend);
            }
            ServletConfig config = null;
            Page page = this._jspManager.createGeneratedPage(path, this._uri, className, config, depends);
            return page;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QJspException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineMap writeJspDoc(WriteStream os, Document doc, Transformer transformer, CauchoRequest req, CauchoResponse res) throws IOException, ServletException {
        PageContext pageContext;
        JspFactory factory;
        block8: {
            factory = JspFactory.getDefaultFactory();
            TransformerImpl xform = null;
            if (transformer instanceof TransformerImpl) {
                xform = (TransformerImpl)transformer;
            }
            String errorPage = null;
            if (xform != null) {
                errorPage = (String)xform.getProperty("caucho.error.page");
            }
            pageContext = factory.getPageContext(this, req, res, errorPage, false, 8192, false);
            if (xform != null) {
                xform.setProperty("caucho.page.context", pageContext);
                xform.setProperty("caucho.pwd", Vfs.lookup());
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(os);
            xform.setFeature("caucho.generate.location", true);
            transformer.transform(source, result);
            if (xform == null) break block8;
            LineMap lineMap = (LineMap)xform.getProperty("caucho.line-map");
            Object var14_15 = null;
            factory.releasePageContext(pageContext);
            return lineMap;
        }
        try {
            LineMap lineMap = null;
            Object var14_16 = null;
            factory.releasePageContext(pageContext);
            return lineMap;
        }
        catch (Exception e) {
            try {
                pageContext.handlePageException(e);
                Object var14_17 = null;
                factory.releasePageContext(pageContext);
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                factory.releasePageContext(pageContext);
                throw throwable;
            }
        }
        return null;
    }

    private String getStylesheetHref(Document doc, String media) throws XPathException {
        Iterator iter = XPath.select("//processing-instruction('xml-stylesheet')", doc);
        while (iter.hasNext()) {
            ProcessingInstruction pi = (ProcessingInstruction)iter.next();
            String value = pi.getNodeValue();
            String piMedia = XmlUtil.getPIAttribute(value, "media");
            if (piMedia != null && !piMedia.equals(media)) continue;
            return XmlUtil.getPIAttribute(value, "href");
        }
        return "default.xsl";
    }

    private boolean varyMedia(Document doc) throws XPathException {
        Iterator iter = XPath.select("//processing-instruction('xml-stylesheet')", doc);
        while (iter.hasNext()) {
            ProcessingInstruction pi = (ProcessingInstruction)iter.next();
            String value = pi.getNodeValue();
            String piMedia = XmlUtil.getPIAttribute(value, "media");
            if (piMedia == null) continue;
            return true;
        }
        return false;
    }

    public boolean disableLog() {
        return true;
    }

    public String toString() {
        return "XtpPage[" + this._uri + "]";
    }
}

