/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.AnalyzedTag;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.JspResourceManager;
import com.caucho.jsp.TagFileManager;
import com.caucho.jsp.TagInfoImpl;
import com.caucho.jsp.Taglib;
import com.caucho.jsp.TaglibManager;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.xml.QName;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagInfo;

public class ParseTagManager {
    static final L10N L = new L10N(ParseTagManager.class);
    private static final Logger log = Logger.getLogger(ParseTagManager.class.getName());
    private JspResourceManager _resourceManager;
    private TaglibManager _taglibManager;
    private TagFileManager _tagFileManager;
    private HashMap<QName, TagInfo> _tagMap = new HashMap();
    private HashMap<String, Taglib> _taglibMap = new HashMap();

    public ParseTagManager(JspResourceManager resourceManager, TaglibManager taglibManager, TagFileManager tagFileManager) throws JspParseException, IOException {
        this._resourceManager = resourceManager;
        this._taglibManager = taglibManager;
        this._tagFileManager = tagFileManager;
    }

    public synchronized AnalyzedTag analyzeTag(Class cl) {
        return this._taglibManager.analyzeTag(cl);
    }

    public synchronized TagInfo getTag(QName qname) throws JspParseException {
        TagInfo tag = this.getTagImpl(qname);
        if (tag instanceof TagInfoImpl) {
            ((TagInfoImpl)tag).validate();
        }
        return tag;
    }

    TagInfo addTempTagInfo(QName qname, TagInfo info) {
        if (this._tagMap.get(qname) == null) {
            this._tagMap.put(qname, info);
        }
        return this._tagMap.get(qname);
    }

    private TagInfo getTagImpl(QName qname) throws JspParseException {
        TagInfo tag = this._tagMap.get(qname);
        if (tag != null) {
            return tag;
        }
        tag = this._tagFileManager.getTag(qname.getPrefix(), qname.getLocalName(), qname.getNamespaceURI());
        this._tagMap.put(qname, tag);
        if (tag != null) {
            return tag;
        }
        Taglib taglib = this.addTaglib(qname);
        if (taglib == null) {
            return null;
        }
        String name = qname.getName();
        String tail = qname.getLocalName();
        if (qname.getNamespaceURI() == null) {
            int p = name.lastIndexOf(58);
            if (p < 0) {
                return null;
            }
            tail = name.substring(p + 1);
        }
        if (taglib != null) {
            tag = taglib.getTag(tail);
        }
        if (tag == null) {
            String tagLocation = taglib.getTagFilePath(tail);
            Path path = taglib.getPath();
            if (path != null && tagLocation != null && (tag = this._tagFileManager.getTag(path = path.lookup(tagLocation), qname.getPrefix(), tagLocation)) != null) {
                return tag;
            }
            if (tagLocation != null && (tag = this._tagFileManager.getTag(qname.getPrefix(), tagLocation)) == null) {
                throw new JspParseException(L.l("'{0}' is an unknown tag-file in tag library '{1}'.", (Object)tagLocation, (Object)taglib.getURI()));
            }
        }
        if (tag == null) {
            throw new JspParseException(L.l("'{0}' is an unknown tag in tag library '{1}'.", (Object)tail, (Object)taglib.getURI()));
        }
        this._tagMap.put(qname, tag);
        return tag;
    }

    public synchronized Class getTagClass(QName qname) throws Exception {
        TagInfo tagInfo = this.getTag(qname);
        if (tagInfo == null) {
            return null;
        }
        String className = tagInfo.getTagClassName();
        if (className != null) {
            return this._tagFileManager.loadClass(className);
        }
        return null;
    }

    public synchronized Taglib addTaglib(QName qname) throws JspParseException {
        String prefix = qname.getPrefix();
        Taglib taglib = this._taglibMap.get(prefix);
        if (this._taglibMap.get(prefix) != null) {
            return taglib;
        }
        String uri = qname.getNamespace();
        taglib = this.addTaglib(prefix, uri);
        this._taglibMap.put(prefix, taglib);
        return taglib;
    }

    public synchronized Taglib addTaglib(String prefix, String uri) throws JspParseException {
        Taglib taglib = null;
        boolean hasTld = false;
        if (uri == null) {
            return null;
        }
        if (uri.startsWith("urn:jsptagdir:")) {
            String tagDir = uri.substring("urn:jsptagdir:".length());
            taglib = this.addTaglibDir(prefix, tagDir);
            hasTld = true;
            if (taglib == null) {
                throw this.error(L.l("'{0}' has no matching tag.  The taglib uri must match a <uri> element in a taglib.tld.", (Object)uri));
            }
        } else {
            if (uri.startsWith("urn:jsptld:")) {
                hasTld = true;
                uri = uri.substring("urn:jsptld:".length());
            }
            String location = uri;
            taglib = this._taglibManager.getTaglib(prefix, uri, location);
            if (hasTld && taglib == null) {
                throw this.error(L.l("'{0}' has no matching tag.  The taglib uri must match a <uri> element in a taglib.tld.", (Object)uri));
            }
        }
        return taglib;
    }

    public synchronized Taglib addTaglibDir(String prefix, String dir) throws JspParseException {
        return this._taglibManager.getTaglibDir(prefix, dir);
    }

    public synchronized Taglib addTaglib(String prefix, String uri, String location) throws JspParseException {
        Taglib taglib = this._taglibManager.getTaglib(prefix, uri, location);
        return this.addTaglib(taglib);
    }

    private Taglib addTaglib(Taglib taglib) throws JspParseException {
        if (taglib == null) {
            return null;
        }
        taglib = taglib.copy();
        for (Taglib oldTaglib : this._taglibMap.values()) {
            if (oldTaglib == null) continue;
            oldTaglib.addTaglib(taglib);
            taglib.addTaglib(oldTaglib);
        }
        this._taglibMap.put(taglib.getPrefixString(), taglib);
        return taglib;
    }

    public boolean hasTags() {
        return this._taglibMap != null && this._taglibMap.size() > 1;
    }

    public JspParseException error(String message) {
        return new JspParseException(message);
    }
}

