/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.server.http.AbstractResponseStream;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BodyResponseStream
extends AbstractResponseStream {
    private static final Logger log = Logger.getLogger(BodyResponseStream.class.getName());
    static final L10N L = new L10N(BodyResponseStream.class);
    private static final int SIZE = TempBuffer.SIZE;
    private final byte[] _byteBuffer = new byte[SIZE];
    private final char[] _charBuffer = new char[SIZE];
    private Writer _out;
    private String _encoding;
    private BufferInputStream _in;
    private Reader _encodingReader;

    public boolean isCauchoResponseStream() {
        return true;
    }

    public void setWriter(Writer out) {
        this._out = out;
        this._encoding = null;
        this._encodingReader = null;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void setBufferSize(int size) {
    }

    public int getBufferSize() {
        return SIZE;
    }

    public int getRemaining() {
        return SIZE;
    }

    public char[] getCharBuffer() {
        return this._charBuffer;
    }

    public int getCharOffset() {
        return 0;
    }

    public void setCharOffset(int offset) {
        if (offset > 0) {
            try {
                this._out.write(this._charBuffer, 0, offset);
            }
            catch (IOException e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    public char[] nextCharBuffer(int offset) throws IOException {
        if (offset > 0) {
            this._out.write(this._charBuffer, 0, offset);
        }
        return this._charBuffer;
    }

    public void print(char[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        this._out.write(buf, offset, length);
    }

    public void print(int ch) throws IOException {
        this._out.write(ch);
    }

    public int getBufferOffset() {
        return 0;
    }

    public void setBufferOffset(int offset) {
        if (offset > 0) {
            try {
                this.write(this._byteBuffer, 0, offset);
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public byte[] getBuffer() {
        return this._byteBuffer;
    }

    public byte[] nextBuffer(int offset) throws IOException {
        if (offset > 0) {
            this.write(this._byteBuffer, 0, offset);
        }
        return this._byteBuffer;
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        int ch;
        if (length == 0) {
            return;
        }
        if (this._encodingReader == null) {
            if (this._in == null) {
                this._in = new BufferInputStream();
            }
            this._encodingReader = Encoding.getReadEncoding(this._in, this._encoding);
        }
        if (this._encodingReader == null) {
            while (length > 0) {
                this.print((char)(buf[offset++] & 0xFF));
                --length;
            }
            return;
        }
        this._in.init(buf, offset, length);
        while ((ch = this._encodingReader.read()) >= 0) {
            this.print(ch);
        }
    }

    public void write(int ch) throws IOException {
        if (this._encodingReader == null) {
            if (this._in == null) {
                this._in = new BufferInputStream();
            }
            this._byteBuffer[0] = (byte)ch;
            this._encodingReader = Encoding.getReadEncoding(this._in, this._encoding);
        }
        if (this._encodingReader == null) {
            this.print((char)ch);
            return;
        }
        this._in.init(this._byteBuffer, 0, 1);
        while ((ch = this._encodingReader.read()) >= 0) {
            this.print(ch);
        }
    }

    public void flushBuffer() throws IOException {
    }

    public void clearBuffer() {
    }

    static class BufferInputStream
    extends InputStream {
        private byte[] _buffer;
        private int _offset;
        private int _length;

        BufferInputStream() {
        }

        void init(byte[] buffer, int offset, int length) {
            this._buffer = buffer;
            this._offset = offset;
            this._length = length;
        }

        public int read() {
            if (this._offset < this._length) {
                return this._buffer[this._offset++] & 0xFF;
            }
            return -1;
        }
    }
}

