/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.json;

import com.caucho.json.ser.JsonSerializer;
import com.caucho.json.ser.JsonSerializerFactory;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;

public class JsonOutput {
    private static final char[] NULL = new char[]{'n', 'u', 'l', 'l'};
    private static final char[] TRUE = new char[]{'t', 'r', 'u', 'e'};
    private static final char[] FALSE = new char[]{'f', 'a', 'l', 's', 'e'};
    private JsonSerializerFactory _factory = new JsonSerializerFactory();
    private PrintWriter _os;

    public JsonOutput() {
    }

    public JsonOutput(PrintWriter os) {
        this.init(os);
    }

    public JsonOutput(WriteStream out) {
        this.init(out.getPrintWriter());
    }

    public void init(PrintWriter os) {
        this._os = os;
    }

    public void writeObject(Object value) throws IOException {
        this.writeObject(value, false);
    }

    public void writeObject(Object value, boolean annotated) throws IOException {
        PrintWriter os = this._os;
        if (value == null) {
            os.write(NULL, 0, 4);
            return;
        }
        JsonSerializer ser = this._factory.getSerializer(value.getClass(), annotated);
        ser.write(this, value, annotated);
    }

    public void writeNull() throws IOException {
        PrintWriter os = this._os;
        os.write(NULL, 0, 4);
    }

    public void writeBoolean(boolean value) throws IOException {
        PrintWriter os = this._os;
        if (value) {
            os.write(TRUE, 0, 4);
        } else {
            os.write(FALSE, 0, 5);
        }
    }

    public void writeLong(long value) throws IOException {
        this.writeStringValue(String.valueOf(value));
    }

    public void writeDouble(double value) throws IOException {
        this.writeStringValue(String.valueOf(value));
    }

    public void writeString(String v) throws IOException {
        PrintWriter os = this._os;
        if (v == null) {
            os.write(NULL, 0, 4);
            return;
        }
        os.write(34);
        int length = v.length();
        for (int i = 0; i < length; ++i) {
            char ch = v.charAt(i);
            this.writeChar(os, ch);
        }
        os.write(34);
    }

    public void writeString(char[] v, int offset, int length) throws IOException {
        PrintWriter os = this._os;
        os.write(34);
        for (int i = 0; i < length; ++i) {
            char ch = v[offset + i];
            this.writeChar(os, ch);
        }
        os.write(34);
    }

    private void writeChar(PrintWriter os, char ch) throws IOException {
        switch (ch) {
            case '\u0000': {
                os.write(92);
                os.write(117);
                os.write(48);
                os.write(48);
                os.write(48);
                os.write(48);
                break;
            }
            case '\n': {
                os.write(92);
                os.write(110);
                break;
            }
            case '\r': {
                os.write(92);
                os.write(114);
                break;
            }
            case '\t': {
                os.write(92);
                os.write(116);
                break;
            }
            case '\b': {
                os.write(92);
                os.write(98);
                break;
            }
            case '\f': {
                os.write(92);
                os.write(102);
                break;
            }
            case '\\': {
                os.write(92);
                os.write(92);
                break;
            }
            case '\"': {
                os.write(92);
                os.write(34);
                break;
            }
            default: {
                os.write(ch);
            }
        }
    }

    public void writeArrayBegin() throws IOException {
        this._os.write(91);
    }

    public void writeArrayComma() throws IOException {
        this._os.write(44);
    }

    public void writeArrayEnd() throws IOException {
        this._os.write(93);
    }

    public void writeMapBegin() throws IOException {
        this._os.write(123);
    }

    public void writeMapComma() throws IOException {
        this._os.write(44);
    }

    public void writeMapEntry(String key, Object value) throws IOException {
        this.writeMapEntry(key, value, false);
    }

    public void writeMapEntry(String key, Object value, boolean annotated) throws IOException {
        this.writeString(key);
        this._os.write(58);
        this.writeObject((Serializable)value, annotated);
    }

    public void writeMapEnd() throws IOException {
        this._os.write(125);
    }

    private void writeStringValue(String s) throws IOException {
        PrintWriter os = this._os;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            os.write(ch);
        }
    }

    public void flushBuffer() throws IOException {
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }
}

