/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.resource;

import com.caucho.config.ConfigException;
import com.caucho.jms.JmsConnectionFactory;
import com.caucho.jms.queue.AbstractDestination;
import com.caucho.services.message.MessageSender;
import com.caucho.services.message.MessageServiceException;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;

public class MessageSenderResource
implements MessageSender {
    private static final L10N L = new L10N(MessageSenderResource.class);
    private ConnectionFactory _connFactory;
    private Connection _conn;
    private Destination _destination;

    public void setConnectionFactory(ConnectionFactory factory) {
        this._connFactory = factory;
    }

    public void setDestination(Destination destination) {
        this._destination = destination;
    }

    @PostConstruct
    public void init() throws JMSException, ConfigException {
        if (this._destination == null) {
            throw new ConfigException(L.l("'destination' required for message sender."));
        }
        if (this._connFactory == null && this._destination instanceof AbstractDestination) {
            this._connFactory = new JmsConnectionFactory();
        }
        if (this._connFactory == null) {
            throw new ConfigException(L.l("'connection-factory' required for message sender"));
        }
        this._conn = this._connFactory.createConnection();
        if (this._conn == null) {
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(HashMap header, Object value) throws MessageServiceException {
        try {
            Session session = this.getSession();
            try {
                Message message;
                if (value == null) {
                    message = session.createMessage();
                } else if (value instanceof String) {
                    message = session.createTextMessage((String)value);
                } else if (value instanceof Serializable) {
                    ObjectMessage objMessage = session.createObjectMessage();
                    objMessage.setObject((Serializable)value);
                    message = objMessage;
                } else {
                    throw new MessageServiceException(L.l("value '{0}' must be serializable", value));
                }
                MessageProducer producer = session.createProducer(this._destination);
                producer.send(message);
                producer.close();
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                session.close();
                throw throwable;
            }
            session.close();
            {
            }
        }
        catch (MessageServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageServiceException(e);
        }
    }

    private Session getSession() throws JMSException {
        return this._conn.createSession(false, 1);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._destination + "]";
    }
}

