/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.queue;

import com.caucho.jms.queue.AbstractDestination;
import com.caucho.jms.queue.MessageCallback;
import com.caucho.jms.queue.MessageException;
import com.caucho.jms.queue.MessageQueue;
import com.caucho.jms.queue.QueueAdmin;
import com.caucho.jms.queue.QueueEntry;
import com.caucho.jms.queue.QueueEntrySelector;
import com.caucho.util.CurrentTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueue<E>
extends AbstractDestination<E>
implements Queue,
MessageQueue<E>,
BlockingQueue<E> {
    private static final Logger log = Logger.getLogger(AbstractQueue.class.getName());
    private QueueAdmin _admin;
    private long _listenerFailCount;
    private long _listenerFailLastTime;

    protected AbstractQueue() {
    }

    public void setQueueName(String name) {
        this.setName(name);
    }

    protected void init() {
    }

    @PostConstruct
    public void postConstruct() {
        try {
            this.init();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        this._admin = new QueueAdmin(this);
        this._admin.register();
    }

    @Override
    public QueueEntry<E> receiveEntry(long expireTime, boolean isAutoAck) {
        return null;
    }

    public QueueEntry<E> receiveEntry(long expireTime, boolean isAutoAck, QueueEntrySelector selector) throws MessageException {
        return this.receiveEntry(expireTime, isAutoAck);
    }

    public void receive(long expireTime, boolean isAutoAck, QueueEntrySelector selector, MessageCallback callback) throws MessageException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void addMessageCallback(MessageCallback<E> callback, boolean isAutoAck) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void removeMessageCallback(MessageCallback<E> entryCallback) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void acknowledge(String msgId) {
    }

    @Override
    public void rollback(String msgId) {
    }

    @Override
    public E receive(long expireTime, boolean isAutoAcknowledge) throws MessageException {
        return this.receive(expireTime, isAutoAcknowledge, null);
    }

    public E receive(long expireTime, boolean isAutoAcknowledge, QueueEntrySelector selector) throws MessageException {
        QueueEntry<E> entry = this.receiveEntry(expireTime, isAutoAcknowledge, selector);
        if (entry != null) {
            return entry.getPayload();
        }
        return null;
    }

    public ArrayList<? extends QueueEntry<E>> getBrowserList() {
        return new ArrayList();
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean offer(E message, long timeout, TimeUnit unit) {
        int priority = 0;
        timeout = unit.toMillis(timeout);
        long expires = CurrentTime.getCurrentTime() + timeout;
        String publisherId = null;
        this.send(this.generateMessageID(), message, priority, expires, publisherId);
        return true;
    }

    @Override
    public boolean offer(E message) {
        return this.offer(message, 0L, TimeUnit.SECONDS);
    }

    @Override
    public void put(E value) {
        this.offer(value, Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public E poll(long timeout, TimeUnit unit) {
        long msTimeout = unit.toMillis(timeout);
        long expireTime = msTimeout + CurrentTime.getCurrentTime();
        E payload = this.receive(expireTime, true);
        try {
            return payload;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException(e);
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public E poll() {
        return this.poll(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public E take() {
        return this.poll(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        E msg;
        int count = 0;
        while ((msg = this.poll()) != null) {
            c.add(msg);
            ++count;
        }
        return count;
    }

    @Override
    public int drainTo(Collection<? super E> c, int max) {
        E msg;
        int count;
        for (count = 0; count < max && (msg = this.poll()) != null; ++count) {
            c.add(msg);
        }
        return count;
    }

    public int getConsumerCount() {
        return 0;
    }

    public int getReceiverCount() {
        return 0;
    }

    public int getQueueSize() {
        return -1;
    }

    public long getListenerFailCountTotal() {
        return this._listenerFailCount;
    }

    public long getListenerFailLastTime() {
        return this._listenerFailLastTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListenerException(Exception e) {
        AbstractQueue abstractQueue = this;
        synchronized (abstractQueue) {
            ++this._listenerFailCount;
            this._listenerFailLastTime = CurrentTime.getCurrentTime();
        }
    }

    @Override
    @PreDestroy
    public void close() {
        super.close();
    }
}

