/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.message;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.message.MessageType;
import com.caucho.jms.message.ObjectConverter;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.NullEnumeration;
import com.caucho.vfs.TempOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
implements Message,
Serializable {
    protected static final Logger log = Logger.getLogger(MessageImpl.class.getName());
    protected static final L10N L = new L10N(MessageImpl.class);
    private static final HashSet<String> _reserved = new HashSet();
    private volatile transient WeakReference<JmsSession> _sessionRef;
    private String _messageId;
    private String _correlationId;
    private long _timestamp;
    private long _expiration;
    private transient Destination _destination;
    private transient Destination _replyTo;
    private int _deliveryMode = 2;
    private boolean _isRedelivered;
    private String _messageType;
    private int _priority = 4;
    private long _sequence;
    private HashMap<String, Object> _properties;
    private transient boolean _isHeaderWriteable = true;
    private transient boolean _isBodyWriteable = true;

    public MessageImpl() {
    }

    public MessageImpl(Message msg) throws JMSException {
        this._messageId = msg.getJMSMessageID();
        this._correlationId = msg.getJMSCorrelationID();
        this._timestamp = msg.getJMSTimestamp();
        this._expiration = msg.getJMSExpiration();
        this._destination = msg.getJMSDestination();
        this._replyTo = msg.getJMSReplyTo();
        this._deliveryMode = msg.getJMSDeliveryMode();
        this._isRedelivered = msg.getJMSRedelivered();
        this._messageType = msg.getJMSType();
        this._priority = msg.getJMSPriority();
        Enumeration e = msg.getPropertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            this.setObjectProperty(name, msg.getObjectProperty(name));
        }
        this._isHeaderWriteable = true;
        this._isBodyWriteable = true;
    }

    public MessageImpl(MessageImpl msg) {
        if (msg._properties != null) {
            this._properties = new HashMap<String, Object>(msg._properties);
        }
        this._messageId = msg._messageId;
        this._correlationId = msg._correlationId;
        this._timestamp = msg._timestamp;
        this._expiration = msg._expiration;
        this._destination = msg._destination;
        this._replyTo = msg._replyTo;
        this._deliveryMode = msg._deliveryMode;
        this._isRedelivered = msg._isRedelivered;
        this._messageType = msg._messageType;
        this._priority = msg._priority;
        this._isHeaderWriteable = false;
        this._isBodyWriteable = false;
    }

    public void setSession(JmsSession session) {
        this._sessionRef = new WeakReference<JmsSession>(session);
    }

    public MessageType getType() {
        return MessageType.NULL;
    }

    @Override
    public String getJMSMessageID() {
        return this._messageId;
    }

    @Override
    public void setJMSMessageID(String id) {
        this._messageId = id;
    }

    @Override
    public long getJMSTimestamp() throws JMSException {
        return this._timestamp;
    }

    @Override
    public void setJMSTimestamp(long time) throws JMSException {
        this._timestamp = time;
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        try {
            if (this._correlationId == null) {
                return null;
            }
            return this._correlationId.getBytes("UTF8");
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] id) throws JMSException {
        try {
            this._correlationId = new String(id, 0, id.length, "UTF8");
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public String getJMSCorrelationID() throws JMSException {
        return this._correlationId;
    }

    @Override
    public void setJMSCorrelationID(String id) throws JMSException {
        this._correlationId = id;
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        return this._replyTo;
    }

    @Override
    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this._replyTo = replyTo;
    }

    @Override
    public Destination getJMSDestination() throws JMSException {
        return this._destination;
    }

    @Override
    public void setJMSDestination(Destination destination) throws JMSException {
        this._destination = destination;
    }

    @Override
    public int getJMSDeliveryMode() throws JMSException {
        return this._deliveryMode;
    }

    @Override
    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this._deliveryMode = deliveryMode;
    }

    @Override
    public boolean getJMSRedelivered() {
        return this._isRedelivered;
    }

    @Override
    public void setJMSRedelivered(boolean isRedelivered) {
        this._isRedelivered = isRedelivered;
    }

    @Override
    public String getJMSType() throws JMSException {
        return this._messageType;
    }

    @Override
    public void setJMSType(String type) throws JMSException {
        this._messageType = type;
    }

    @Override
    public long getJMSExpiration() throws JMSException {
        return this._expiration;
    }

    @Override
    public void setJMSExpiration(long time) throws JMSException {
        this._expiration = time;
    }

    @Override
    public int getJMSPriority() {
        return this._priority;
    }

    @Override
    public void setJMSPriority(int priority) {
        this._priority = priority;
    }

    @Override
    public void clearProperties() throws JMSException {
        if (this._properties != null) {
            this._properties.clear();
        }
        this._isHeaderWriteable = true;
    }

    @Override
    public boolean propertyExists(String name) throws JMSException {
        if (this._properties == null) {
            return false;
        }
        return this._properties.keySet().contains(name);
    }

    @Override
    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value != null) {
            return ObjectConverter.toBoolean(value);
        }
        return false;
    }

    @Override
    public byte getByteProperty(String name) throws JMSException {
        return ObjectConverter.toByte(this.getObjectProperty(name));
    }

    @Override
    public short getShortProperty(String name) throws JMSException {
        return ObjectConverter.toShort(this.getObjectProperty(name));
    }

    @Override
    public int getIntProperty(String name) throws JMSException {
        return ObjectConverter.toInt(this.getObjectProperty(name));
    }

    @Override
    public long getLongProperty(String name) throws JMSException {
        return ObjectConverter.toLong(this.getObjectProperty(name));
    }

    @Override
    public float getFloatProperty(String name) throws JMSException {
        return ObjectConverter.toFloat(this.getObjectProperty(name));
    }

    @Override
    public double getDoubleProperty(String name) throws JMSException {
        return ObjectConverter.toDouble(this.getObjectProperty(name));
    }

    @Override
    public String getStringProperty(String name) throws JMSException {
        Object prop = this.getObjectProperty(name);
        if (prop == null) {
            return null;
        }
        return String.valueOf(prop);
    }

    @Override
    public Object getObjectProperty(String name) throws JMSException {
        if (this._properties == null || name == null) {
            return null;
        }
        return this._properties.get(name);
    }

    @Override
    public Enumeration getPropertyNames() throws JMSException {
        if (this._properties == null) {
            return NullEnumeration.create();
        }
        return Collections.enumeration(this._properties.keySet());
    }

    @Override
    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setObjectProperty(name, new Boolean(value));
    }

    @Override
    public void setByteProperty(String name, byte value) throws JMSException {
        this.setObjectProperty(name, new Byte(value));
    }

    @Override
    public void setShortProperty(String name, short value) throws JMSException {
        this.setObjectProperty(name, new Short(value));
    }

    @Override
    public void setIntProperty(String name, int value) throws JMSException {
        this.setObjectProperty(name, new Integer(value));
    }

    @Override
    public void setLongProperty(String name, long value) throws JMSException {
        this.setObjectProperty(name, new Long(value));
    }

    @Override
    public void setFloatProperty(String name, float value) throws JMSException {
        this.setObjectProperty(name, new Float(value));
    }

    @Override
    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setObjectProperty(name, new Double(value));
    }

    @Override
    public void setStringProperty(String name, String value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    @Override
    public void setObjectProperty(String name, Object value) throws JMSException {
        this.checkPropertyWriteable();
        if (name == null) {
            throw new NullPointerException();
        }
        if ("".equals(name)) {
            throw new IllegalArgumentException();
        }
        if (MessageImpl.isReserved(name)) {
            throw new JMSException(L.l("'{0}' is a reserved property name.", (Object)name));
        }
        if (!(value == null || value instanceof Number || value instanceof String || value instanceof Boolean)) {
            throw new MessageFormatException(L.l("{0} is an illegal object property value", (Object)value.getClass().getName()));
        }
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put(name, value);
    }

    @Override
    public void acknowledge() throws JMSException {
        JmsSession session;
        WeakReference<JmsSession> sessionRef = this._sessionRef;
        this._sessionRef = null;
        if (sessionRef != null && (session = (JmsSession)sessionRef.get()) != null) {
            session.acknowledge();
        }
    }

    @Override
    public void clearBody() throws JMSException {
        this._isBodyWriteable = true;
    }

    public void setReceive() throws JMSException {
        this._isHeaderWriteable = false;
        this._isBodyWriteable = false;
    }

    protected void setBodyReadOnly() {
        this._isBodyWriteable = false;
    }

    public HashMap<String, Object> getProperties() {
        return this._properties;
    }

    public long getSequence() {
        return this._sequence;
    }

    public void setSequence(long seq) {
        this._sequence = seq;
    }

    public MessageImpl copy() {
        MessageImpl msg = new MessageImpl();
        this.copy(msg);
        return msg;
    }

    public InputStream propertiesToInputStream() throws IOException {
        if (this._properties == null || this._properties.size() == 0) {
            return null;
        }
        TempOutputStream out = new TempOutputStream();
        this.writeProperties(out);
        out.close();
        return out.openRead();
    }

    public void writeProperties(OutputStream os) throws IOException {
        if (this._properties == null || this._properties.size() == 0) {
            return;
        }
        Hessian2Output out = new Hessian2Output(os);
        out.writeString(this._messageId);
        out.writeBoolean(this._isRedelivered);
        out.writeInt(this._priority);
        out.writeLong(this._timestamp);
        out.writeInt(this._deliveryMode);
        if (this._destination instanceof Serializable) {
            out.writeObject(this._destination);
        } else {
            out.writeObject(null);
        }
        if (this._replyTo instanceof Serializable) {
            out.writeObject(this._replyTo);
        } else {
            out.writeObject(null);
        }
        for (Map.Entry<String, Object> entry : this._properties.entrySet()) {
            out.writeString(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.close();
    }

    public void readProperties(InputStream is) throws IOException, JMSException {
        if (is == null) {
            return;
        }
        Hessian2Input in = new Hessian2Input(is);
        this._messageId = in.readString();
        this._isRedelivered = in.readBoolean();
        this._priority = in.readInt();
        this._timestamp = in.readLong();
        this._deliveryMode = in.readInt();
        this._destination = (Destination)in.readObject();
        this._replyTo = (Destination)in.readObject();
        while (!in.isEnd()) {
            String key = in.readString();
            Object value = in.readObject();
            this.setObjectProperty(key, value);
        }
        in.close();
    }

    public InputStream bodyToInputStream() throws IOException {
        return null;
    }

    public void writeBody(OutputStream os) throws IOException {
    }

    public void readBody(InputStream is) throws IOException, JMSException {
    }

    protected void checkHeaderWriteable() throws JMSException {
        if (!this._isHeaderWriteable) {
            throw new MessageNotWriteableException(L.l("received messages can't be written."));
        }
    }

    protected void checkPropertyWriteable() throws JMSException {
        if (!this._isHeaderWriteable) {
            throw new MessageNotWriteableException(L.l("properties for received messages are read-only."));
        }
    }

    protected void checkBodyWriteable() throws JMSException {
        if (!this._isBodyWriteable) {
            throw new MessageNotWriteableException(L.l("received messages can't be written."));
        }
    }

    protected void checkBodyReadable() throws JMSException {
        if (this._isBodyWriteable) {
            throw new MessageNotReadableException(L.l("write-only messages can't be read until reset() is called."));
        }
    }

    protected void copy(MessageImpl newMsg) {
        if (this._properties != null) {
            newMsg._properties = new HashMap<String, Object>(this._properties);
        }
        newMsg._messageId = this._messageId;
        newMsg._correlationId = this._correlationId;
        newMsg._timestamp = this._timestamp;
        newMsg._expiration = this._expiration;
        newMsg._destination = this._destination;
        newMsg._replyTo = this._replyTo;
        newMsg._deliveryMode = this._deliveryMode;
        newMsg._isRedelivered = this._isRedelivered;
        newMsg._messageType = this._messageType;
        newMsg._priority = this._priority;
    }

    public String toString() {
        if (this._messageId != null) {
            return this.getClass().getSimpleName() + "[" + this._messageId + "]";
        }
        if (CurrentTime.isTest()) {
            return this.getClass().getSimpleName() + "[]";
        }
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this);
    }

    public static boolean isReserved(String name) {
        return _reserved.contains(name.toUpperCase(Locale.ENGLISH));
    }

    static {
        _reserved.add("TRUE");
        _reserved.add("FALSE");
        _reserved.add("NULL");
        _reserved.add("NOT");
        _reserved.add("AND");
        _reserved.add("OR");
        _reserved.add("BETWEEN");
        _reserved.add("LIKE");
        _reserved.add("IN");
        _reserved.add("IS");
        _reserved.add("ESCAPE");
    }
}

