/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jca;

import com.caucho.config.ConfigException;
import com.caucho.jms.jca.ManagedSessionImpl;
import com.caucho.jms.jca.MessageSenderImpl;
import com.caucho.jms.jca.ResourceAdapterImpl;
import com.caucho.util.L10N;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.security.auth.Subject;

public class MessageSenderManager
implements ManagedConnectionFactory,
ResourceAdapterAssociation {
    protected static final Logger log = Logger.getLogger(MessageSenderManager.class.getName());
    private static final L10N L = new L10N(MessageSenderManager.class);
    private ResourceAdapterImpl _ra;

    public ResourceAdapter getResourceAdapter() {
        return this._ra;
    }

    public void setResourceAdapter(ResourceAdapter adapter) throws ResourceException {
        if (!(adapter instanceof ResourceAdapterImpl)) {
            throw new ResourceException(L.l("'{0}' is not a valid resource-adapter for MessageSenderManager.", (Object)adapter.getClass().getName()));
        }
        this._ra = (ResourceAdapterImpl)adapter;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._ra == null) {
            throw new ConfigException(L.l("MessageSenderManager must be configured with a resource adapter"));
        }
    }

    public Object createConnectionFactory(ConnectionManager connManager) throws ResourceException {
        return new MessageSenderImpl(this, connManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo requestInfo) throws ResourceException {
        ResourceAdapterImpl ra = this._ra;
        return new ManagedSessionImpl(ra.getConnectionFactory(), ra.getDestination());
    }

    public ManagedConnection matchManagedConnections(Set connSet, Subject subject, ConnectionRequestInfo requestInfo) throws ResourceException {
        Iterator iter = connSet.iterator();
        if (iter.hasNext()) {
            ManagedSessionImpl mConn = (ManagedSessionImpl)iter.next();
            return mConn;
        }
        return null;
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    public void setLogWriter(PrintWriter log) {
    }
}

