/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.cfg.AbstractBeanConfig;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;

public class JavaMailConfig
extends AbstractBeanConfig {
    private Properties _props = new Properties();
    private Authenticator _auth;
    private String _user;
    private String _password;
    private Session _session;

    public JavaMailConfig() {
        this.setClass(Session.class);
    }

    public void setAuthenticator(Authenticator auth) {
        this._auth = auth;
    }

    public void setFrom(String from) {
        this.setProperty("mail.from", from);
    }

    public void setHost(String host) {
        this.setProperty("mail.host", host);
    }

    public void setImapHost(String host) {
        this.setProperty("mail.imap.host", host);
    }

    public void setImapUser(String user) {
        this.setProperty("mail.imap.user", user);
    }

    public void setPop3Host(String host) {
        this.setProperty("mail.pop3.host", host);
    }

    public void setPop3User(String user) {
        this.setProperty("mail.pop3.user", user);
    }

    public void setSmtpAuth(boolean isEnable) {
        this.setProperty("mail.smtp.auth", isEnable ? "true" : "false");
    }

    public void setSmtpHost(String host) {
        this.setProperty("mail.smtp.host", host);
    }

    public void setSmtpSsl(boolean ssl) {
        this.setProperty("mail.smtp.ssl", String.valueOf(ssl));
    }

    public void setSmtpPort(int port) {
        this.setProperty("mail.smtp.port", String.valueOf(port));
    }

    public void setSmtpUser(String user) {
        this.setProperty("mail.smtp.user", user);
    }

    public void setStoreProtocol(String protocol) {
        this.setProperty("mail.store.protocol", protocol);
    }

    public void setTransportProtocol(String protocol) {
        this.setProperty("mail.transport.protocol", protocol);
    }

    public void setUser(String user) {
        this._user = user;
        this.setProperty("mail.user", user);
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setProperty(String name, String value) {
        this._props.put(name, value);
    }

    public void setProperties(Properties props) {
        this._props.putAll((Map<?, ?>)props);
    }

    public void setValue(Properties props) {
        this._props.putAll((Map<?, ?>)props);
    }

    public void initImpl() throws ConfigException {
        super.initImpl();
        try {
            Authenticator auth;
            if (this.getInit() != null) {
                this.getInit().configure(this);
            }
            if ((auth = this._auth) == null && this._user != null && this._password != null) {
                auth = new StandardAuthenticator(this._user, this._password);
            }
            this._session = auth != null ? Session.getInstance((Properties)this._props, (Authenticator)auth) : Session.getInstance((Properties)this._props);
            this.deploy();
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public Object replaceObject() {
        return this._session;
    }

    static class StandardAuthenticator
    extends Authenticator {
        private final String _userName;
        private final PasswordAuthentication _passwordAuth;

        StandardAuthenticator(String userName, String password) {
            this._userName = userName;
            this._passwordAuth = new PasswordAuthentication(userName, password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this._passwordAuth;
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this._userName + "]";
        }
    }
}

