/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java.gen;

import com.caucho.java.JavaWriter;
import com.caucho.java.gen.CallChain;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;

public class MethodCallChain
extends CallChain {
    private static L10N L = new L10N(MethodCallChain.class);
    private Method _method;
    private String _methodName;
    private Class[] _parameterTypes;
    private Class _returnType;

    public MethodCallChain() {
    }

    public MethodCallChain(Method method) {
        this._method = method;
        this._methodName = method.getName();
        this._parameterTypes = method.getParameterTypes();
        this._returnType = method.getReturnType();
    }

    public MethodCallChain(String methodName, Class[] params, Class returnType) {
        this._methodName = methodName;
        this._parameterTypes = params;
        this._returnType = returnType;
    }

    public Method getMethod() {
        return this._method;
    }

    public Class[] getParameterTypes() {
        return this._parameterTypes;
    }

    public Class getReturnType() {
        return this._returnType;
    }

    public void generateCall(JavaWriter out, String retVar, String var, String[] args) throws IOException {
        if (!this.getReturnType().getName().equals("void")) {
            if (retVar != null) {
                out.print(retVar + " = ");
            } else {
                out.print("return ");
            }
        }
        if (var != null) {
            out.print(var + ".");
        } else {
            out.print("super.");
        }
        out.print(this._methodName + "(");
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print(args[i]);
        }
        out.println(");");
    }
}

