/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.inject;

import com.caucho.inject.ThreadScoped;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

public class ThreadContext {
    private static final L10N L = new L10N(ThreadContext.class);
    private static final ThreadLocal<HashMap<Contextual<?>, Object>> _threadMap = new ThreadLocal();
    private static ThreadContextImpl _context = new ThreadContextImpl();

    public static void begin() {
        if (_threadMap.get() != null) {
            throw new IllegalStateException(L.l("ThreadContext begin() must not be recursive"));
        }
        HashMap map = new HashMap(8);
        _threadMap.set(map);
    }

    public static void end() {
        if (_threadMap.get() == null) {
            throw new IllegalStateException(L.l("ThreadContext end() does not have a matching begin"));
        }
        _threadMap.set(null);
    }

    public static Context getContext() {
        return _context;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ThreadContextImpl
    implements Context {
        ThreadContextImpl() {
        }

        @Override
        public <T> T get(Contextual<T> bean) {
            HashMap map = (HashMap)_threadMap.get();
            if (map == null) {
                throw new IllegalStateException(L.l("@ThreadScoped is not active for {0}", (Object)Thread.currentThread()));
            }
            return (T)map.get(bean);
        }

        @Override
        public <T> T get(Contextual<T> bean, CreationalContext<T> env) {
            HashMap map = (HashMap)_threadMap.get();
            if (map == null) {
                throw new IllegalStateException(L.l("@ThreadScoped is not active for {0}", (Object)Thread.currentThread()));
            }
            Object instance = map.get(bean);
            if (instance == null) {
                instance = bean.create(env);
                map.put(bean, instance);
            }
            return (T)instance;
        }

        @Override
        public Class<? extends Annotation> getScope() {
            return ThreadScoped.class;
        }

        @Override
        public boolean isActive() {
            return _threadMap.get() != null;
        }
    }
}

