/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp;

import com.caucho.bam.BamError;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianDebugOutputStream;
import com.caucho.hmtp.HmtpPacketType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HmtpWriter {
    private static final Logger log = Logger.getLogger(HmtpWriter.class.getName());
    private String _address;
    private Hessian2Output _out;
    private HessianDebugOutputStream _dOut;
    private int _addressCacheIndex;
    private HashMap<String, Integer> _addressCache = new HashMap(256);
    private String[] _addressCacheRing = new String[256];

    public HmtpWriter() {
        this._out = new Hessian2Output();
        if (log.isLoggable(Level.FINEST)) {
            this._dOut = new HessianDebugOutputStream(log, Level.FINEST);
        }
    }

    protected void init(OutputStream os) {
        if (this._dOut != null) {
            this._dOut.initPacket(os);
            os = this._dOut;
        }
        this._out.initPacket(os);
    }

    public String getAddress() {
        return this._address;
    }

    public void setAddress(String address) {
        this._address = address;
    }

    public void message(OutputStream os, String to, String from, Serializable payload) throws IOException {
        this.init(os);
        Hessian2Output out = this._out;
        if (out == null) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " message " + payload + " {to:" + to + ", from:" + from + "}");
        }
        out.writeInt(HmtpPacketType.MESSAGE.ordinal());
        this.writeAddress(out, to);
        this.writeAddress(out, from);
        out.writeObject(payload);
        out.flushBuffer();
    }

    public void messageError(OutputStream os, String to, String from, Serializable value, BamError error) throws IOException {
        this.init(os);
        Hessian2Output out = this._out;
        if (out == null) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " messageError " + value + " {to:" + to + ", from:" + from + "}");
        }
        out.writeInt(HmtpPacketType.MESSAGE_ERROR.ordinal());
        this.writeAddress(out, to);
        this.writeAddress(out, from);
        out.writeObject(value);
        out.writeObject(error);
        out.flushBuffer();
    }

    public void query(OutputStream os, long id, String to, String from, Serializable value) throws IOException {
        this.init(os);
        Hessian2Output out = this._out;
        if (out == null) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " query " + value + " {id: " + id + ", to:" + to + ", from:" + from + "}");
        }
        out.writeInt(HmtpPacketType.QUERY.ordinal());
        this.writeAddress(out, to);
        this.writeAddress(out, from);
        out.writeLong(id);
        out.writeObject(value);
        out.flushBuffer();
    }

    public void queryResult(OutputStream os, long id, String to, String from, Serializable value) throws IOException {
        this.init(os);
        Hessian2Output out = this._out;
        if (out == null) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " queryResult " + value + " {id: " + id + ", to:" + to + ", from:" + from + "}");
        }
        out.writeInt(HmtpPacketType.QUERY_RESULT.ordinal());
        this.writeAddress(out, to);
        this.writeAddress(out, from);
        out.writeLong(id);
        out.writeObject(value);
        out.flushBuffer();
    }

    public void queryError(OutputStream os, long id, String to, String from, Serializable value, BamError error) throws IOException {
        this.init(os);
        Hessian2Output out = this._out;
        if (out == null) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " queryError " + error + " " + value + " {id: " + id + ", to:" + to + ", from:" + from + "}");
        }
        out.writeInt(HmtpPacketType.QUERY_ERROR.ordinal());
        this.writeAddress(out, to);
        this.writeAddress(out, from);
        out.writeLong(id);
        out.writeObject(value);
        out.writeObject(error);
        out.flushBuffer();
    }

    private void writeAddress(Hessian2Output out, String address) throws IOException {
        if (address == null) {
            out.writeString(null);
            return;
        }
        Integer value = this._addressCache.get(address);
        if (value != null) {
            out.writeInt(value);
        } else {
            out.writeString(address);
            int index = this._addressCacheIndex;
            this._addressCacheIndex = (index + 1) % this._addressCacheRing.length;
            if (this._addressCacheRing[index] != null) {
                this._addressCache.remove(this._addressCacheRing[index]);
            }
            this._addressCacheRing[index] = address;
            this._addressCache.put(address, index);
        }
    }

    public void flush() throws IOException {
        Hessian2Output out = this._out;
        if (out != null) {
            out.flush();
        }
    }

    public void close() {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " close");
        }
        try {
            Hessian2Output out = this._out;
            this._out = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddress() + "]";
    }
}

