/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp;

import com.caucho.bam.BamError;
import com.caucho.bam.ProtocolException;
import com.caucho.bam.broker.AbstractBroker;
import com.caucho.hmtp.HmtpWriter;
import com.caucho.remote.websocket.WebSocketOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HmtpWebSocketWriter
extends AbstractBroker {
    private static final Logger log = Logger.getLogger(HmtpWebSocketWriter.class.getName());
    private String _address;
    private WebSocketOutputStream _wsOut;
    private HmtpWriter _hOut;
    private final AtomicInteger _useCount = new AtomicInteger();

    public HmtpWebSocketWriter(OutputStream os) throws IOException {
        this._wsOut = new WebSocketOutputStream(os, new byte[1024]);
        this._hOut = new HmtpWriter();
    }

    public String getAddress() {
        return this._address;
    }

    public void setAddress(String address) {
        this._address = address;
    }

    public void setAutoFlush(boolean isFlush) {
        this._wsOut.setAutoFlush(isFlush);
    }

    public void message(String to, String from, Serializable payload) {
        try {
            try {
                this.startWrite();
                this._wsOut.init();
                this._hOut.message(this._wsOut, to, from, payload);
                this._wsOut.close();
            }
            catch (IOException e) {
                throw new ProtocolException(e);
            }
            Object var6_4 = null;
            this.endWrite();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.endWrite();
            throw throwable;
        }
    }

    public void messageError(String to, String from, Serializable payload, BamError error) {
        try {
            try {
                this.startWrite();
                this._wsOut.init();
                this._hOut.messageError(this._wsOut, to, from, payload, error);
                this._wsOut.close();
            }
            catch (IOException e) {
                throw new ProtocolException(e);
            }
            Object var7_5 = null;
            this.endWrite();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.endWrite();
            throw throwable;
        }
    }

    public void query(long id, String to, String from, Serializable payload) {
        try {
            try {
                this.startWrite();
                this._wsOut.init();
                this._hOut.query(this._wsOut, id, to, from, payload);
                this._wsOut.close();
            }
            catch (IOException e) {
                throw new ProtocolException(e);
            }
            Object var8_5 = null;
            this.endWrite();
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.endWrite();
            throw throwable;
        }
    }

    public void queryResult(long id, String to, String from, Serializable payload) {
        try {
            try {
                this.startWrite();
                this._wsOut.init();
                this._hOut.queryResult(this._wsOut, id, to, from, payload);
                this._wsOut.close();
            }
            catch (IOException e) {
                throw new ProtocolException(e);
            }
            Object var8_5 = null;
            this.endWrite();
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.endWrite();
            throw throwable;
        }
    }

    public void queryError(long id, String to, String from, Serializable payload, BamError error) {
        try {
            this._wsOut.init();
            this._hOut.queryError(this._wsOut, id, to, from, payload, error);
            this._wsOut.close();
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
    }

    public boolean isClosed() {
        return false;
    }

    public void flush() {
        try {
            this._wsOut.flush();
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public void close() {
    }

    private void startWrite() {
        if (this._useCount.incrementAndGet() > 1) {
            // empty if block
        }
    }

    private void endWrite() {
        this._useCount.decrementAndGet();
    }
}

