/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.servlet;

import com.caucho.bam.NotAuthorizedException;
import com.caucho.cloud.security.SecurityService;
import com.caucho.config.Admin;
import com.caucho.config.inject.InjectManager;
import com.caucho.hmtp.NonceQuery;
import com.caucho.hmtp.SignedCredentials;
import com.caucho.security.Authenticator;
import com.caucho.security.BasicPrincipal;
import com.caucho.security.DigestCredentials;
import com.caucho.security.PasswordCredentials;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.lang.annotation.Annotation;
import java.security.Key;
import java.security.KeyPair;
import java.security.Principal;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.enterprise.util.AnnotationLiteral;

public class ServerAuthManager {
    private static final Logger log = Logger.getLogger(ServerAuthManager.class.getName());
    private static final L10N L = new L10N(ServerAuthManager.class);
    private SecurityService _security;
    private Authenticator _auth;
    private KeyPair _authKeyPair;
    private boolean _isAuthenticationRequired = true;
    private LruCache<String, String> _nonceMap = new LruCache(4096);

    public ServerAuthManager() {
        this._security = SecurityService.getCurrent();
        InjectManager cdiManager = InjectManager.getCurrent();
        this._auth = cdiManager.getReference(Authenticator.class, new AnnotationLiteral<Admin>(){});
        if (this._auth == null) {
            this._auth = cdiManager.getReference(Authenticator.class, new Annotation[0]);
        }
    }

    public void setAuthenticationRequired(boolean isAuthenticationRequired) {
        this._isAuthenticationRequired = isAuthenticationRequired;
    }

    public Authenticator getAuth() {
        if (this._auth != null) {
            return this._auth;
        }
        return this._security.getAuthenticator();
    }

    public boolean isClusterSystemKey() {
        return this._security.isSystemAuthKey();
    }

    public Key decryptKey(String keyAlgorithm, byte[] encKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(4, this._authKeyPair.getPrivate());
            Key key = cipher.unwrap(encKey, keyAlgorithm, 3);
            return key;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void authenticate(String to, Object credentials, String ipAddress) {
        Authenticator auth = this.getAuth();
        if (credentials instanceof SignedCredentials) {
            String serverSignature;
            SignedCredentials signedCred = (SignedCredentials)credentials;
            String uid = signedCred.getUid();
            String nonce = signedCred.getNonce();
            String signature = signedCred.getSignature();
            if (uid != null && !uid.equals("")) {
                serverSignature = this._security.signSystem(uid, nonce);
            } else if (this._security.isSystemAuthKey() || !this._isAuthenticationRequired) {
                serverSignature = this._security.signSystem(uid, nonce);
            } else {
                log.info("Authentication failed because cluster-system-key is not configured");
                throw new NotAuthorizedException(L.l("No user and password credentials were presented and cluster-system-key is not configured"));
            }
            if (!serverSignature.equals(signature)) {
                throw new NotAuthorizedException(L.l("'{0}' has invalid credentials", (Object)uid));
            }
        } else if (auth != null || this._isAuthenticationRequired) {
            if (auth == null) {
                log.finer("Authentication failed because no authenticator configured");
                throw new NotAuthorizedException(L.l("'{0}' has missing authenticator", credentials));
            }
            if (credentials instanceof DigestCredentials) {
                DigestCredentials digestCred = (DigestCredentials)credentials;
                Principal user = new BasicPrincipal(digestCred.getUserName());
                if ((user = auth.authenticate(user, digestCred, null)) == null) {
                    throw new NotAuthorizedException(L.l("'{0}' has invalid digest credentials", (Object)digestCred.getUserName()));
                }
            } else if (credentials instanceof String) {
                BasicPrincipal user = new BasicPrincipal(to);
                String password = (String)credentials;
                PasswordCredentials pwdCred = new PasswordCredentials(password);
                if (auth.authenticate(user, pwdCred, null) == null) {
                    throw new NotAuthorizedException(L.l("'{0}' has invalid password credentials", (Object)to));
                }
            } else {
                throw new NotAuthorizedException(L.l("'{0}' is an unknown credential", credentials));
            }
        }
    }

    NonceQuery generateNonce(NonceQuery query) {
        String uid = query.getUid();
        String clientNonce = query.getNonce();
        String clientSignature = this._security.signSystem(uid, clientNonce);
        String algorithm = this._security.getAlgorithm(uid);
        String nonce = String.valueOf(CurrentTime.getCurrentTime());
        return new NonceQuery(algorithm, uid, nonce, clientSignature);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAuth() + "]";
    }
}

