/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.filters;

import com.caucho.filters.CauchoResponseWrapper;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class MD5Filter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        DigestResponse digestResponse = new DigestResponse(response);
        nextFilter.doFilter(request, digestResponse);
        digestResponse.finish();
    }

    public void destroy() {
    }

    static class DigestStream
    extends OutputStream {
        private OutputStream _os;
        private MessageDigest _digest;

        DigestStream(OutputStream os) {
            this._os = os;
            try {
                this._digest = MessageDigest.getInstance("MD5");
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void write(int ch) throws IOException {
            this._os.write(ch);
            this._digest.update((byte)ch);
        }

        public void write(byte[] buffer, int offset, int length) throws IOException {
            this._os.write(buffer, offset, length);
            this._digest.update(buffer, offset, length);
        }

        public void flush() throws IOException {
            this._os.flush();
        }

        public void close() throws IOException {
            this._os.close();
        }

        public String getDigest() {
            byte[] bytes = this._digest.digest();
            CharBuffer cb = new CharBuffer();
            Base64.encode(cb, bytes, 0, bytes.length);
            return cb.toString();
        }
    }

    class DigestResponse
    extends CauchoResponseWrapper {
        private DigestStream _digestStream;

        DigestResponse(ServletResponse response) {
            super((HttpServletResponse)response);
        }

        public void setContentLength(int length) {
        }

        protected OutputStream getStream() throws IOException {
            if (this._digestStream == null) {
                this._digestStream = new DigestStream(this._response.getOutputStream());
            }
            return this._digestStream;
        }

        public void finish() throws IOException, ServletException {
            if (this._digestStream != null) {
                this._digestStream.flush();
            }
            this.close();
            if (this._digestStream != null) {
                this._digestStream.flush();
                super.setFooter("Content-MD5", this._digestStream.getDigest());
            }
        }
    }
}

