/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread2;

import com.caucho.env.thread.TaskWorker;
import com.caucho.env.warning.WarningService;
import com.caucho.loader.Environment;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractTaskWorker2
implements Runnable,
TaskWorker,
Closeable {
    private static Logger _log;
    private static final long PERMANENT_TIMEOUT = 30000L;
    private static final AtomicLong _idGen;
    private final AtomicReference<State> _state = new AtomicReference<State>(State.IDLE);
    private final WeakReference<ClassLoader> _classLoaderRef;
    private String _threadName;
    private long _workerIdleTimeout = 500L;
    private volatile Thread _thread;

    protected AbstractTaskWorker2(ClassLoader classLoader) {
        this._classLoaderRef = new WeakReference<ClassLoader>(classLoader);
        Environment.addWeakCloseListener(this, classLoader);
    }

    protected boolean isPermanent() {
        return false;
    }

    protected void setWorkerIdleTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        this._workerIdleTimeout = timeout;
    }

    public final boolean isTaskActive() {
        return this._state.get().isActive() || this._state.get().isPark();
    }

    public boolean isClosed() {
        return this._state.get().isClosed();
    }

    public String getState() {
        return String.valueOf((Object)this._state.get());
    }

    protected ClassLoader getClassLoader() {
        return (ClassLoader)this._classLoaderRef.get();
    }

    public abstract long runTask();

    public void close() {
        this._state.getAndSet(State.CLOSED);
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public final void wake() {
        Thread thread;
        State newState;
        State oldState;
        while (!this._state.compareAndSet(oldState = this._state.get(), newState = oldState.toWake())) {
        }
        if (oldState.isIdle()) {
            this.startWorkerThread();
        } else if (oldState.isPark() && (thread = this._thread) != null) {
            this.unpark(thread);
        }
    }

    protected abstract void startWorkerThread();

    protected void unpark(Thread thread) {
        LockSupport.unpark(thread);
    }

    protected String getThreadName() {
        if (this._threadName == null) {
            this._threadName = this.toString() + "-" + _idGen.incrementAndGet();
        }
        return this._threadName;
    }

    protected boolean isRetry() {
        return false;
    }

    protected void onThreadStart() {
    }

    protected void onThreadComplete() {
    }

    private long getIdleTimeout() {
        if (this.isPermanent()) {
            return 30000L;
        }
        return this._workerIdleTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        String oldName;
        Thread thread;
        block14: {
            block13: {
                thread = Thread.currentThread();
                oldName = thread.getName();
                try {
                    try {
                        Thread oldThread = this._thread;
                        this._thread = thread;
                        if (oldThread != null) {
                            System.out.println("DOUBLE_THREAD: " + oldThread);
                        }
                        thread.setContextClassLoader(this.getClassLoader());
                        thread.setName(this.getThreadName());
                        this.onThreadStart();
                        long now = this.getCurrentTimeActual();
                        long idleTimeout = this.getIdleTimeout();
                        long expires = idleTimeout > 0L ? now + idleTimeout : 0L;
                        boolean isExpireRetry = false;
                        do {
                            State oldState;
                            isExpireRetry = false;
                            do {
                                if (!(oldState = this._state.get()).isClosed()) continue;
                                Object var15_11 = null;
                                this._thread = null;
                                this.completeThread(thread, oldName);
                                return;
                            } while (!this._state.compareAndSet(oldState, State.ACTIVE));
                            do {
                                if (this._state.get().isClosed()) {
                                    break block13;
                                }
                                thread.setContextClassLoader(this.getClassLoader());
                                isExpireRetry = false;
                                long delta = this.runTask();
                                now = this.getCurrentTimeActual();
                                if (delta > 0L) {
                                    expires = now + delta;
                                    isExpireRetry = true;
                                    continue;
                                }
                                expires = idleTimeout > 0L ? now + idleTimeout : 0L;
                            } while (this._state.compareAndSet(State.ACTIVE_WAKE, State.ACTIVE));
                            if (expires > 0L && this._state.compareAndSet(State.ACTIVE, State.PARK)) {
                                thread.setName(this.getThreadName());
                                Thread.interrupted();
                                if (!this.isRetry() && this._state.get() == State.PARK) {
                                    LockSupport.parkUntil(expires);
                                }
                                this._state.compareAndSet(State.PARK, State.ACTIVE);
                            }
                            now = this.getCurrentTimeActual();
                            if (!this.isPermanent() && !isExpireRetry) continue;
                            expires = now + idleTimeout;
                        } while (this.isPermanent() || isExpireRetry || now < expires || this._state.get() == State.ACTIVE_WAKE || this.isRetry());
                        break block14;
                    }
                    catch (Throwable e) {
                        System.out.println("EXN: " + e);
                        WarningService.sendCurrentWarning((Object)this, e);
                        this.log().log(Level.WARNING, e.toString(), e);
                        Object var15_14 = null;
                        this._thread = null;
                        this.completeThread(thread, oldName);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    this._thread = null;
                    this.completeThread(thread, oldName);
                    throw throwable;
                }
            }
            Object var15_12 = null;
            this._thread = null;
            this.completeThread(thread, oldName);
            return;
        }
        Object var15_13 = null;
        this._thread = null;
        this.completeThread(thread, oldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void completeThread(Thread thread, String oldName) {
        State newState2;
        State oldState2;
        try {
            this.onThreadComplete();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            State newState2;
            State oldState2;
            Object var4_4 = null;
            while (!this._state.compareAndSet(oldState2 = this._state.get(), newState2 = oldState2.toIdle())) {
            }
            if (newState2.isWake()) {
                boolean isValid = false;
                try {
                    this.startWorkerThread();
                    isValid = true;
                    Object var9_13 = null;
                    if (!isValid) {
                        System.err.println("Warning: resetting actor." + this);
                        this._state.set(State.IDLE);
                    }
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    if (isValid) throw throwable2;
                    System.err.println("Warning: resetting actor." + this);
                    this._state.set(State.IDLE);
                    throw throwable2;
                }
            }
            thread.setName(oldName);
            throw throwable;
        }
        while (!this._state.compareAndSet(oldState2 = this._state.get(), newState2 = oldState2.toIdle())) {
        }
        if (newState2.isWake()) {
            boolean isValid = false;
            try {}
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (isValid) throw throwable;
                System.err.println("Warning: resetting actor." + this);
                this._state.set(State.IDLE);
                throw throwable;
            }
            this.startWorkerThread();
            isValid = true;
            Object var9_11 = null;
            if (!isValid) {
                System.err.println("Warning: resetting actor." + this);
                this._state.set(State.IDLE);
            }
        }
        thread.setName(oldName);
    }

    protected long getCurrentTimeActual() {
        return System.currentTimeMillis();
    }

    private Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(AbstractTaskWorker2.class.getName());
        }
        return _log;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static {
        _idGen = new AtomicLong();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        IDLE{

            boolean isIdle() {
                return true;
            }

            State toWake() {
                return ACTIVE_WAKE;
            }
        }
        ,
        ACTIVE{

            State toWake() {
                return ACTIVE_WAKE;
            }

            boolean isActive() {
                return true;
            }

            State toIdle() {
                return IDLE;
            }
        }
        ,
        ACTIVE_WAKE{

            State toWake() {
                return this;
            }

            boolean isActive() {
                return true;
            }

            boolean isWake() {
                return true;
            }

            State toIdle() {
                return this;
            }
        }
        ,
        PARK{

            State toWake() {
                return ACTIVE_WAKE;
            }

            State toIdle() {
                return IDLE;
            }

            boolean isPark() {
                return true;
            }
        }
        ,
        CLOSED{

            boolean isClosed() {
                return true;
            }

            State toWake() {
                return CLOSED;
            }

            State toIdle() {
                return CLOSED;
            }
        };


        boolean isIdle() {
            return false;
        }

        boolean isActive() {
            return false;
        }

        boolean isWake() {
            return false;
        }

        boolean isPark() {
            return false;
        }

        boolean isClosed() {
            return false;
        }

        State toWake() {
            return ACTIVE_WAKE;
        }

        State toIdle() {
            throw new UnsupportedOperationException(this.toString());
        }
    }
}

