/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread1;

import com.caucho.env.thread1.ThreadLauncher1;
import com.caucho.env.thread1.ThreadPool1;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ResinThread1
extends Thread {
    private static final Logger log = Logger.getLogger(ResinThread1.class.getName());
    private final int _id;
    private final String _name;
    private final ThreadPool1 _pool;
    private final ThreadLauncher1 _launcher;
    private volatile ResinThread1 _next;
    private boolean _isClose;
    private volatile ClassLoader _taskLoader;
    private final AtomicReference<Runnable> _taskRef = new AtomicReference();

    ResinThread1(int id, ThreadPool1 pool, ThreadLauncher1 launcher) {
        this._id = id;
        this._name = "resin-" + this._id;
        this._pool = pool;
        this._launcher = launcher;
        this.setDaemon(true);
    }

    public String getDebugName() {
        return this._name;
    }

    public long getThreadId() {
        return this.getId();
    }

    final ResinThread1 getNext() {
        return this._next;
    }

    final void setNext(ResinThread1 thread) {
        this._next = thread;
    }

    final boolean scheduleTask(Runnable task, ClassLoader loader) {
        if (this._isClose) {
            return false;
        }
        this._taskLoader = loader;
        if (this._taskRef.getAndSet(task) != null) {
            System.out.println("BAD: getandset");
        }
        LockSupport.unpark(this);
        return true;
    }

    final void close() {
        this._isClose = true;
        LockSupport.unpark(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this._launcher.onChildThreadBegin();
                this.runTasks();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
                Object var3_2 = null;
                this._launcher.onChildThreadEnd();
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._launcher.onChildThreadEnd();
            throw throwable;
        }
        this._launcher.onChildThreadEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasks() {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        ResinThread1 thread = this;
        this.setName(this._name);
        while (!this._isClose) {
            Object var7_6;
            Runnable task = null;
            ClassLoader classLoader = null;
            if (this._launcher.isIdleExpire()) {
                return;
            }
            task = this.waitForTask();
            if (task == null) {
                return;
            }
            classLoader = this._taskLoader;
            this._taskLoader = null;
            try {
                try {
                    thread.setContextClassLoader(classLoader);
                    task.run();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                    var7_6 = null;
                    thread.setContextClassLoader(systemClassLoader);
                    continue;
                }
                var7_6 = null;
                thread.setContextClassLoader(systemClassLoader);
            }
            catch (Throwable throwable) {
                var7_6 = null;
                thread.setContextClassLoader(systemClassLoader);
                throw throwable;
            }
        }
    }

    private Runnable waitForTask() {
        this._pool.beginIdle(this);
        while (!this._isClose) {
            Runnable task = this._taskRef.getAndSet(null);
            if (task != null) {
                return task;
            }
            this.setName(this._name);
            Thread.interrupted();
            LockSupport.park();
        }
        return null;
    }
}

