/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread;

import com.caucho.config.ConfigException;
import com.caucho.env.thread2.ThreadPool2;
import com.caucho.util.L10N;
import java.util.concurrent.atomic.AtomicReference;

public final class ThreadPool
extends ThreadPool2 {
    private static final L10N L = new L10N(ThreadPool.class);
    private static final AtomicReference<ThreadPool> _globalThreadPool = new AtomicReference();
    private static final int DEFAULT_EXECUTOR_TASK_MAX = 16;
    private static final long MAX_EXPIRE = 0x3FFFFFFFFFFFFFFFL;
    private int _executorTaskMax = 16;
    private final Object _executorLock = new Object();
    private int _executorTaskCount;
    private ExecutorQueueItem _executorQueueHead;
    private ExecutorQueueItem _executorQueueTail;

    public ThreadPool() {
    }

    public ThreadPool(String name) {
        super(name);
    }

    public static ThreadPool getCurrent() {
        return ThreadPool.getThreadPool();
    }

    public static ThreadPool getThreadPool() {
        ThreadPool pool = _globalThreadPool.get();
        if (pool == null) {
            pool = new ThreadPool();
            if (_globalThreadPool.compareAndSet(null, pool = pool.setAsGlobal())) {
                pool.start();
            } else {
                pool = _globalThreadPool.get();
            }
        }
        return pool;
    }

    protected ThreadPool setAsGlobal() {
        if (_globalThreadPool.compareAndSet(null, this)) {
            this.start();
            this.setAsGlobal(this);
            return this;
        }
        return _globalThreadPool.get();
    }

    public void setExecutorTaskMax(int max) {
        if (this.getThreadMax() < max) {
            throw new ConfigException(L.l("<thread-executor-max> ({0}) must be less than <thread-max> ({1})", max, this.getThreadMax()));
        }
        if (max == 0) {
            throw new ConfigException(L.l("<thread-executor-max> must not be zero."));
        }
        this._executorTaskMax = max;
    }

    public int getExecutorTaskMax() {
        return this._executorTaskMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleExecutorTask(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Object object = this._executorLock;
        synchronized (object) {
            ++this._executorTaskCount;
            if (this._executorTaskCount <= this._executorTaskMax || this._executorTaskMax < 0) {
                boolean isPriority = false;
                boolean isQueue = true;
                boolean isWake = true;
                return this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue, isWake);
            }
            ExecutorQueueItem item = new ExecutorQueueItem(task, loader);
            if (this._executorQueueTail != null) {
                this._executorQueueTail._next = item;
            } else {
                this._executorQueueHead = item;
            }
            this._executorQueueTail = item;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeExecutorTask() {
        ExecutorQueueItem item = null;
        Object object = this._executorLock;
        synchronized (object) {
            --this._executorTaskCount;
            assert (this._executorTaskCount >= 0);
            if (this._executorQueueHead != null) {
                item = this._executorQueueHead;
                this._executorQueueHead = item._next;
                if (this._executorQueueHead == null) {
                    this._executorQueueTail = null;
                }
            }
        }
        if (item != null) {
            Runnable task = item.getRunnable();
            ClassLoader loader = item.getLoader();
            boolean isPriority = false;
            boolean isQueue = true;
            boolean isWake = true;
            this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue, isWake);
        }
    }

    static class ExecutorQueueItem {
        Runnable _runnable;
        ClassLoader _loader;
        ExecutorQueueItem _next;

        ExecutorQueueItem(Runnable runnable, ClassLoader loader) {
            this._runnable = runnable;
            this._loader = loader;
        }

        Runnable getRunnable() {
            return this._runnable;
        }

        ClassLoader getLoader() {
            return this._loader;
        }
    }
}

