/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.service;

import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.java.WorkDir;
import com.caucho.util.L10N;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.Path;
import java.io.IOException;

public class RootDirectorySystem
extends AbstractResinSubSystem {
    public static final int START_PRIORITY_ROOT_DIRECTORY = 20;
    private static final L10N L = new L10N(RootDirectorySystem.class);
    private final Path _rootDirectory;
    private final Path _dataDirectory;

    public RootDirectorySystem(Path rootDirectory, Path dataDirectory) throws IOException {
        if (rootDirectory == null) {
            throw new NullPointerException();
        }
        if (dataDirectory == null) {
            throw new NullPointerException();
        }
        if (dataDirectory instanceof MemoryPath) {
            dataDirectory = WorkDir.getTmpWorkDir().lookup("qa/" + dataDirectory.getFullPath());
        }
        this._rootDirectory = rootDirectory;
        this._dataDirectory = dataDirectory;
        rootDirectory.mkdirs();
        dataDirectory.mkdirs();
    }

    public static RootDirectorySystem createAndAddService(Path rootDirectory) throws IOException {
        return RootDirectorySystem.createAndAddService(rootDirectory, rootDirectory.lookup("resin-data"));
    }

    public static RootDirectorySystem createAndAddService(Path rootDirectory, Path dataDirectory) throws IOException {
        ResinSystem system = RootDirectorySystem.preCreate(RootDirectorySystem.class);
        RootDirectorySystem service = new RootDirectorySystem(rootDirectory, dataDirectory);
        system.addService(RootDirectorySystem.class, service);
        return service;
    }

    public static RootDirectorySystem getCurrent() {
        return ResinSystem.getCurrentService(RootDirectorySystem.class);
    }

    public static Path getCurrentDataDirectory() {
        RootDirectorySystem rootService = RootDirectorySystem.getCurrent();
        if (rootService == null) {
            throw new IllegalStateException(L.l("{0} must be active for getCurrentDataDirectory().", (Object)RootDirectorySystem.class.getSimpleName()));
        }
        return rootService.getDataDirectory();
    }

    public Path getRootDirectory() {
        return this._rootDirectory;
    }

    public Path getDataDirectory() {
        return this._dataDirectory;
    }

    public int getStartPriority() {
        return 20;
    }
}

