/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import java.util.Comparator;

public class ExpandVersion {
    private static final VersionNameComparator _comparator = new VersionNameComparator();
    private final String _key;
    private final String _baseKey;
    private final String _version;

    ExpandVersion(String key, String baseKey, String version) {
        this._key = key;
        this._baseKey = baseKey;
        this._version = version;
    }

    public String getKey() {
        return this._key;
    }

    public String getBaseKey() {
        return this._baseKey;
    }

    public String getVersion() {
        return this._version;
    }

    int compareTo(ExpandVersion version) {
        return _comparator.compare(version.getVersion(), this.getVersion());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpandVersion)) {
            return false;
        }
        ExpandVersion version = (ExpandVersion)o;
        return this.getKey().equals(version.getKey());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getKey() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VersionNameComparator
    implements Comparator<String> {
        VersionNameComparator() {
        }

        @Override
        public int compare(String versionA, String versionB) {
            if (versionA.equals(versionB)) {
                return 0;
            }
            if (versionA.isEmpty()) {
                return 1;
            }
            if (versionB.isEmpty()) {
                return -1;
            }
            int lengthA = versionA.length();
            int lengthB = versionB.length();
            int indexA = 0;
            int indexB = 0;
            while (indexA < lengthA && indexB < lengthB) {
                char chB;
                char chA;
                int valueA = 0;
                int valueB = 0;
                while (indexA < lengthA && '0' <= (chA = versionA.charAt(indexA)) && chA <= '9') {
                    valueA = 10 * valueA + chA - 48;
                    ++indexA;
                }
                while (indexB < lengthB && '0' <= (chB = versionB.charAt(indexB)) && chB <= '9') {
                    valueB = 10 * valueB + chB - 48;
                    ++indexB;
                }
                if (valueA < valueB) {
                    return 1;
                }
                if (valueB < valueA) {
                    return -1;
                }
                while (!(indexA >= lengthA || indexB >= lengthB || '0' <= (chA = versionA.charAt(indexA)) && chA <= '9' || '0' <= (chB = versionB.charAt(indexB)) && chB <= '9')) {
                    if (chA < chB) {
                        return 1;
                    }
                    if (chB < chA) {
                        return -1;
                    }
                    ++indexA;
                    ++indexB;
                }
                if (indexA < lengthA && ('0' > (chA = versionA.charAt(indexA)) || chA > '9')) {
                    return 1;
                }
                if (indexB >= lengthB || '0' <= (chB = versionB.charAt(indexB)) && chB <= '9') continue;
                return -1;
            }
            if (indexA != lengthA) {
                return 1;
            }
            if (indexB != lengthB) {
                return -1;
            }
            return 0;
        }
    }
}

