/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.env.deploy.DeployTagItem;
import com.caucho.env.deploy.DeployTagListener;
import com.caucho.env.deploy.DeployUpdateListener;
import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.inject.Module;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class DeployControllerService
extends AbstractResinSubSystem {
    public static final int START_PRIORITY = 50;
    private final ConcurrentHashMap<String, DeployTagItem> _deployMap = new ConcurrentHashMap();
    private final List<DeployTagListener> _tagListeners = new CopyOnWriteArrayList<DeployTagListener>();
    private final List<DeployUpdateListener> _updateListeners = new CopyOnWriteArrayList<DeployUpdateListener>();

    public static DeployControllerService createAndAddService() {
        ResinSystem system = DeployControllerService.preCreate(DeployControllerService.class);
        DeployControllerService service = new DeployControllerService();
        system.addService(DeployControllerService.class, service);
        return service;
    }

    public static DeployControllerService getCurrent() {
        return ResinSystem.getCurrentService(DeployControllerService.class);
    }

    public DeployTagItem addTag(String tagName) {
        DeployTagItem item = new DeployTagItem(tagName);
        DeployTagItem oldItem = this._deployMap.putIfAbsent(tagName, item);
        if (oldItem != null) {
            return oldItem;
        }
        for (DeployTagListener listener : this._tagListeners) {
            listener.onTagAdd(tagName);
        }
        return item;
    }

    public void removeTag(String tagName) {
        DeployTagItem oldItem = this._deployMap.remove(tagName);
        if (oldItem != null) {
            for (DeployTagListener listener : this._tagListeners) {
                listener.onTagRemove(tagName);
            }
        }
    }

    public Set<String> getTagNames() {
        return this._deployMap.keySet();
    }

    public DeployTagItem getTagItem(String tag) {
        return this._deployMap.get(tag);
    }

    public void addTagListener(DeployTagListener listener) {
        this._tagListeners.add(listener);
        for (String tag : this._deployMap.keySet()) {
            listener.onTagAdd(tag);
        }
    }

    public void removeTagListener(DeployTagListener listener) {
        this._tagListeners.remove(listener);
    }

    public void update(String tag) {
        for (DeployUpdateListener listener : this._updateListeners) {
            listener.onUpdate(tag);
        }
    }

    public void addUpdateListener(DeployUpdateListener listener) {
        this._updateListeners.add(listener);
    }

    public void removeUpdateListener(DeployUpdateListener listener) {
        this._updateListeners.remove(listener);
    }

    @Override
    public int getStartPriority() {
        return 50;
    }
}

