/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.dbpool;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import javax.resource.spi.ManagedConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdlePoolSet
extends AbstractSet<ManagedConnection> {
    private final int _capacity;
    private final ManagedConnection[] _entries;
    private final int _entriesLength;
    private int _head;
    private int _tail;

    IdlePoolSet(int capacity) {
        this._capacity = capacity;
        this._entries = new ManagedConnection[2 * capacity];
        this._entriesLength = this._entries.length;
    }

    @Override
    public int size() {
        return (this._head - this._tail + this._entriesLength) % this._entriesLength;
    }

    @Override
    public boolean isEmpty() {
        return this._head == this._tail;
    }

    public ManagedConnection first() {
        if (this._head != this._tail) {
            return this._entries[this._tail];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(ManagedConnection o) {
        IdlePoolSet idlePoolSet = this;
        synchronized (idlePoolSet) {
            if (this._capacity <= this.size()) {
                return false;
            }
            int i = this._tail;
            while (i != this._head) {
                if (this._entries[i] == o) {
                    return false;
                }
                i = (i + 1) % this._entriesLength;
            }
            this._entries[this._head] = o;
            this._head = (this._head + 1) % this._entriesLength;
        }
        return true;
    }

    @Override
    public void clear() {
        this._tail = 0;
        this._head = 0;
        for (int i = 0; i < this._entriesLength; ++i) {
            this._entries[i] = null;
        }
    }

    @Override
    public boolean contains(Object o) {
        int i = this._tail;
        while (i != this._head) {
            if (this._entries[i] == o) {
                return true;
            }
            i = (i + 1) % this._entriesLength;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<ManagedConnection> iterator() {
        return new IdlePoolIterator();
    }

    @Override
    public boolean remove(Object o) {
        int i = this._tail;
        while (i != this._head) {
            if (this._entries[i] == o) {
                return this.removeEntry(i);
            }
            i = (i + 1) % this._entriesLength;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Iterator<?> iter = c.iterator();
        boolean result = true;
        while (iter.hasNext()) {
            if (this.remove(iter.next())) continue;
            result = false;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Object[] toArray() {
        Object[] values = new Object[this.size()];
        int j = 0;
        int i = this._tail;
        while (i != this._head) {
            values[j++] = this._entries[i];
            i = (i + 1) % this._entriesLength;
        }
        return values;
    }

    public ManagedConnection[] toArray(ManagedConnection[] values) {
        int j = 0;
        int i = this._tail;
        while (i != this._head) {
            values[j++] = this._entries[i];
            i = (i + 1) % this._entriesLength;
        }
        return values;
    }

    boolean removeEntry(int i) {
        if (i == this._head) {
            return false;
        }
        if (i == this._tail) {
            this._entries[this._tail] = null;
        } else if (this._tail < i) {
            System.arraycopy(this._entries, this._tail, this._entries, this._tail + 1, i - this._tail);
        } else {
            if (i > 0) {
                System.arraycopy(this._entries, 0, this._entries, 1, i);
            }
            this._entries[0] = this._entries[this._entriesLength - 1];
            System.arraycopy(this._entries, this._tail, this._entries, this._tail + 1, this._entriesLength - this._tail - 1);
        }
        this._entries[this._tail] = null;
        this._tail = (this._tail + 1) % this._entriesLength;
        return true;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this._entries);
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IdlePoolIterator
    implements Iterator<ManagedConnection> {
        private int _head;
        private int _tail;
        private int _i;

        IdlePoolIterator() {
            this._head = IdlePoolSet.this._head;
            this._i = this._tail = IdlePoolSet.this._tail;
        }

        @Override
        public boolean hasNext() {
            return this._i != this._head;
        }

        @Override
        public ManagedConnection next() {
            if (this._i == this._head) {
                return null;
            }
            ManagedConnection value = IdlePoolSet.this._entries[this._i];
            this._i = (this._i + 1) % IdlePoolSet.this._entriesLength;
            return value;
        }

        @Override
        public void remove() {
            int i = (this._i + IdlePoolSet.this._entriesLength - 1) % IdlePoolSet.this._entriesLength;
            IdlePoolSet.this.removeEntry(i);
            this._tail = IdlePoolSet.this._tail;
        }
    }
}

