/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import java.beans.FeatureDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapVariableResolver
extends ELResolver {
    private Map<String, Object> _map;

    public MapVariableResolver(Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        this._map = map;
    }

    public MapVariableResolver() {
        this(new HashMap<String, Object>());
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (base != null || !(property instanceof String)) {
            return null;
        }
        String var = (String)property;
        Object value = this._map.get(var);
        if (value != null) {
            context.setPropertyResolved(true);
            return value;
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (!(base instanceof String) || property != null) {
            return;
        }
        String var = (String)base;
        context.setPropertyResolved(true);
        this._map.put(var, value);
    }

    public Object put(String var, Object value) {
        return this._map.put(var, value);
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (property != null || !(base instanceof String)) {
            return true;
        }
        context.setPropertyResolved(true);
        return false;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        Object value = this.getValue(context, base, property);
        if (value != null) {
            return value.getClass();
        }
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return null;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Map<String, Object> getMap() {
        return this._map;
    }

    public void setMap(Map<String, Object> map) {
        this._map = map;
    }

    public String toString() {
        return "MapVariableResolver[" + this._map + "]";
    }
}

