/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.el.MethodExpr;
import com.caucho.el.StringLiteral;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayResolverExpr
extends Expr {
    private Expr _left;
    private Expr _right;
    private transient Class _lastClass;
    private transient String _lastField;
    private transient Method _lastMethod;

    public ArrayResolverExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    public Expr getExpr() {
        return this._left;
    }

    public Expr getIndex() {
        return this._right;
    }

    @Override
    public Expr createMethod(Expr[] args) {
        if (!(this._right instanceof StringLiteral)) {
            return null;
        }
        StringLiteral literal = (StringLiteral)this._right;
        return new MethodExpr(this._left, literal.getValue(), args);
    }

    @Override
    public Class<?> getType(ELContext env) throws PropertyNotFoundException, ELException {
        Object aObj = this._left.getValue(env);
        if (aObj == null) {
            return null;
        }
        Object fieldObj = this._right.getValue(env);
        if (fieldObj == null) {
            return null;
        }
        return env.getELResolver().getType(env, aObj, fieldObj);
    }

    @Override
    public Object getValue(ELContext env) throws ELException {
        Object aObj = this._left.getValue(env);
        if (aObj == null) {
            return null;
        }
        Object fieldObj = this._right.getValue(env);
        if (fieldObj == null) {
            return null;
        }
        return env.getELResolver().getValue(env, aObj, fieldObj);
    }

    @Override
    public boolean isReadOnly(ELContext env) throws ELException {
        Object aObj = this._left.getValue(env);
        if (aObj == null) {
            return true;
        }
        Object fieldObj = this._right.getValue(env);
        if (fieldObj == null) {
            return true;
        }
        return env.getELResolver().isReadOnly(env, aObj, fieldObj);
    }

    @Override
    public void setValue(ELContext env, Object value) throws ELException {
        Object aObj = this._left.getValue(env);
        if (aObj == null) {
            throw new PropertyNotFoundException(L.l("'{0}' is null in '{1}'", (Object)this._left.toString(), (Object)this.toString()));
        }
        Object fieldObj = this._right.getValue(env);
        if (fieldObj == null) {
            throw new PropertyNotFoundException(L.l("'{0}' is null in '{1}'", (Object)this._right.toString(), (Object)this.toString()));
        }
        env.getELResolver().setValue(env, aObj, fieldObj, value);
    }

    @Override
    public ValueReference getValueReference(ELContext context) {
        Object base = this._left.getValue(context);
        Object property = this._right.getValue(context);
        return new ValueReference(base, property);
    }

    @Override
    public MethodInfo getMethodInfo(ELContext env, Class<?> returnType, Class<?>[] argTypes) throws ELException {
        Object base = this._left.getValue(env);
        if (base == null) {
            throw new PropertyNotFoundException(L.l("'{0}' not found in context '{1}'.", (Object)this._left.getExpressionString(), (Object)env));
        }
        String name = this._right.evalString(env);
        try {
            Method method = base.getClass().getMethod(name, argTypes);
            return new MethodInfo(this._right.evalString(env), method.getReturnType(), argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new MethodNotFoundException(e);
        }
    }

    @Override
    public Object invoke(ELContext env, Class<?>[] argTypes, Object[] args) throws ELException {
        Object base = this._left.getValue(env);
        if (base == null) {
            throw new PropertyNotFoundException(L.l("'{0}' not found in context '{1}'.", (Object)this._left.getExpressionString(), (Object)env));
        }
        String name = this._right.evalString(env);
        try {
            Method method = base.getClass().getMethod(name, argTypes);
            return method.invoke(base, args);
        }
        catch (NoSuchMethodException e) {
            throw new MethodNotFoundException(e);
        }
        catch (IllegalAccessException e) {
            throw new ELException(e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(e.getCause());
        }
    }

    @Override
    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.ArrayResolverExpr(");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ArrayResolverExpr)) {
            return false;
        }
        ArrayResolverExpr expr = (ArrayResolverExpr)o;
        return this._left.equals(expr._left) && this._right.equals(expr._right);
    }

    @Override
    public String toString() {
        return this._left + "[" + this._right + "]";
    }
}

