/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.session;

import com.caucho.config.ConfigException;
import com.caucho.config.gen.BeanGenerator;
import com.caucho.config.gen.CandiEnhancedBean;
import com.caucho.config.gen.CandiUtil;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.config.j2ee.EJBExceptionWrapper;
import com.caucho.ejb.cfg.EjbLazyGenerator;
import com.caucho.ejb.gen.StatefulGenerator;
import com.caucho.ejb.inject.StatefulBeanImpl;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.server.AbstractContext;
import com.caucho.ejb.server.EjbInjectionTarget;
import com.caucho.ejb.server.SingletonInjectionTarget;
import com.caucho.ejb.session.AbstractSessionContext;
import com.caucho.ejb.session.AbstractSessionManager;
import com.caucho.ejb.session.StatefulContext;
import com.caucho.ejb.session.StatefulProviderProxy;
import com.caucho.ejb.session.StatefulProxy;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.StatefulTimeout;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.SessionBeanType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulManager<X>
extends AbstractSessionManager<X> {
    private static final L10N L = new L10N(StatefulManager.class);
    private static final Logger log = Logger.getLogger(StatefulManager.class.getName());
    private long _idleTimeout = 600000L;
    private AtomicLong _sequence = new AtomicLong(CurrentTime.getCurrentTime());
    private ConcurrentHashMap<String, StatefulProxy> _sessionMap;
    private Object _decoratorClass;
    private List<Decorator<?>> _decoratorBeans;

    public StatefulManager(EjbManager ejbContainer, String ejbName, String moduleName, AnnotatedType<X> rawAnnType, AnnotatedType<X> annotatedType, EjbLazyGenerator<X> lazyGenerator) {
        super(ejbContainer, ejbName, moduleName, rawAnnType, annotatedType, lazyGenerator);
        StatefulTimeout timeout = annotatedType.getAnnotation(StatefulTimeout.class);
        if (timeout != null) {
            this._idleTimeout = timeout.unit().toMillis(timeout.value());
        }
        if (this._idleTimeout < 0L) {
            this._idleTimeout = 0x3FFFFFFFFFFFFFFFL;
        }
    }

    @Override
    protected String getType() {
        return "stateful:";
    }

    @Override
    protected Class<?> getContextClass() {
        return StatefulContext.class;
    }

    @Override
    protected SessionBeanType getSessionBeanType() {
        return SessionBeanType.STATEFUL;
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    @Override
    public void bind() {
        super.bind();
        Class<?> instanceClass = this.getProxyImplClass();
        if (instanceClass != null && CandiEnhancedBean.class.isAssignableFrom(instanceClass)) {
            try {
                Method method = instanceClass.getMethod("__caucho_decorator_init", new Class[0]);
                this._decoratorClass = method.invoke(null, new Object[0]);
                Annotation[] qualifiers = new Annotation[this.getBean().getQualifiers().size()];
                this.getBean().getQualifiers().toArray(qualifiers);
                InjectManager moduleBeanManager = InjectManager.create();
                this._decoratorBeans = moduleBeanManager.resolveDecorators(this.getBean().getTypes(), qualifiers);
                method = instanceClass.getMethod("__caucho_init_decorators", List.class);
                method.invoke(null, this._decoratorBeans);
            }
            catch (InvocationTargetException e) {
                throw ConfigException.create(e.getCause());
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
    }

    @Override
    public <T> StatefulContext<X, T> getSessionContext(Class<T> api) {
        return (StatefulContext)super.getSessionContext(api);
    }

    @Override
    protected EjbInjectionTarget<X> createInjectionTarget() {
        return new SingletonInjectionTarget(this, this.getAnnotatedType());
    }

    @Override
    public <T> Object getLocalJndiProxy(Class<T> api) {
        AbstractSessionContext context = this.getSessionContext((Class)api);
        return new StatefulProviderProxy(context);
    }

    @Override
    public <T> T getLocalProxy(Class<T> api) {
        AbstractSessionContext context = this.getSessionContext((Class)api);
        if (context != null) {
            OwnerCreationalContext env = new OwnerCreationalContext(null);
            Object proxy = ((StatefulContext)context).createProxy(env);
            return proxy;
        }
        return null;
    }

    public Object getStatefulProxy(String key) {
        AnnotatedType annType = this.getLocalBean();
        if (annType != null) {
            return this.getLocalProxy(annType.getJavaClass());
        }
        ArrayList localApi = this.getLocalApi();
        if (localApi.size() > 0) {
            return this.getLocalProxy(localApi.get(0).getJavaClass());
        }
        throw new UnsupportedOperationException(L.l("{0} cannot return proxy for {1} because no @Local interface exists", (Object)this, (Object)key));
    }

    public <T> T initProxy(T instance, CreationalContextImpl<T> env) {
        if (instance instanceof CandiEnhancedBean) {
            CandiEnhancedBean bean = (CandiEnhancedBean)instance;
            Object[] delegates = this.createDelegates(env);
            Object[] interceptors = null;
            bean.__caucho_inject(delegates, interceptors, env);
            try {
                bean.__caucho_postConstruct();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                throw new EJBExceptionWrapper(e.getCause());
            }
            catch (Exception e) {
                throw new EJBExceptionWrapper((Throwable)e);
            }
        }
        if (instance instanceof StatefulProxy) {
            StatefulProxy proxy = (StatefulProxy)instance;
            if (this._sessionMap != null) {
                this._sessionMap.put(proxy.__caucho_getId(), proxy);
            }
        }
        return instance;
    }

    private Object[] createDelegates(CreationalContextImpl<?> env) {
        if (this._decoratorBeans != null) {
            return CandiUtil.generateProxyDelegate(this.getInjectManager(), this._decoratorBeans, this._decoratorClass, env);
        }
        return null;
    }

    @Override
    protected <T> StatefulContext<X, T> createSessionContext(Class<T> api) {
        return new StatefulContext(this, api);
    }

    @Override
    protected <T> Bean<T> createBean(ManagedBeanImpl<X> mBean, Class<T> api, Set<Type> apiList, AnnotatedType<X> extAnnType) {
        AbstractSessionContext context = this.getSessionContext((Class)api);
        if (context == null) {
            throw new NullPointerException(L.l("'{0}' is an unknown api for {1}", (Object)api, (Object)this.getContext()));
        }
        StatefulBeanImpl statefulBean = new StatefulBeanImpl(context, mBean, apiList, extAnnType);
        return statefulBean;
    }

    @Override
    protected BeanGenerator<X> createBeanGenerator() {
        EjbLazyGenerator lazyGen = this.getLazyGenerator();
        return new StatefulGenerator(this.getEJBName(), lazyGen.getBeanType(), lazyGen.getLocalApi(), lazyGen.getLocalBean(), lazyGen.getRemoteApi());
    }

    @Override
    public AbstractContext<X> getContext(Object key, boolean forceLoad) throws FinderException {
        throw new NoSuchEJBException("no matching object:" + key);
    }

    public String generateKey() {
        return String.valueOf(this._sequence.incrementAndGet());
    }

    @Override
    public <T> T getRemoteObject(Class<T> api, String protocol) {
        AbstractSessionContext context = this.getSessionContext((Class)api);
        if (context != null) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
        return null;
    }

    public void remove(String key) {
        if (this._sessionMap != null) {
            this._sessionMap.remove(key);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        ArrayList<StatefulProxy> values = new ArrayList<StatefulProxy>();
        if (this._sessionMap != null) {
            Iterator<StatefulProxy> iter = this._sessionMap.values().iterator();
            while (iter.hasNext()) {
                values.add(iter.next());
            }
        }
        this._sessionMap = null;
        for (StatefulProxy obj : values) {
        }
        log.fine(this + " closed");
    }
}

