/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.server;

import com.caucho.config.gen.CandiInvocationContext;
import com.caucho.ejb.server.AbstractEjbBeanManager;
import com.caucho.security.SecurityContext;
import com.caucho.security.SecurityContextException;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.L10N;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Identity;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBContext;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBMetaData;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext<X>
implements EJBContext {
    private static final L10N L = new L10N(AbstractContext.class);
    private static final Logger log = Logger.getLogger(AbstractContext.class.getName());
    private boolean _isDead;
    private String[] _declaredRoles;
    private Class<?> _invokedBusinessInterface;

    public void setDeclaredRoles(String[] roles) {
        this._declaredRoles = roles;
    }

    public boolean isDead() {
        return this._isDead;
    }

    public abstract AbstractEjbBeanManager<X> getServer();

    public EJBMetaData getEJBMetaData() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public EJBHome getEJBHome() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public EJBLocalHome getEJBLocalHome() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Object lookup(String name) {
        return this.getServer().lookup(name);
    }

    @Override
    public Properties getEnvironment() {
        return new Properties();
    }

    @Override
    public final Map<String, Object> getContextData() {
        return CandiInvocationContext.getCurrentContextData();
    }

    @Override
    public Identity getCallerIdentity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Principal getCallerPrincipal() {
        try {
            return SecurityContext.getUserPrincipal();
        }
        catch (SecurityContextException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    @Override
    public boolean isCallerInRole(Identity role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCallerInRole(String roleName) {
        for (String role : this._declaredRoles) {
            if (!roleName.equals(role)) continue;
            return SecurityContext.isUserInRole(roleName);
        }
        return false;
    }

    @Override
    public UserTransaction getUserTransaction() throws IllegalStateException {
        return this.getServer().getUserTransaction();
    }

    @Override
    public TimerService getTimerService() throws IllegalStateException {
        return this.getServer().getTimerService();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        if (!this.getServer().isContainerTransaction()) {
            throw new IllegalStateException(L.l("setRollbackOnly() is only allowed with container-managed transaction"));
        }
        try {
            TransactionImpl xa = TransactionManagerImpl.getLocal().getCurrent();
            if (xa == null || xa.getStatus() == 6) {
                throw new IllegalStateException(L.l("setRollbackOnly() called with no active transaction."));
            }
            if (Boolean.FALSE.equals(xa.getAttribute("allowRollback"))) {
                throw new IllegalStateException(L.l("setRollbackOnly() called in forbidden context"));
            }
            xa.setRollbackOnly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean getRollbackOnly() throws IllegalStateException {
        if (!this.getServer().isContainerTransaction()) {
            throw new IllegalStateException(L.l("getRollbackOnly() is only allowed with container-managed transaction"));
        }
        TransactionImpl xa = TransactionManagerImpl.getLocal().getCurrent();
        if (xa == null || xa.getStatus() == 6) {
            throw new IllegalStateException(L.l("getRollbackOnly() called with no active transaction."));
        }
        if (Boolean.FALSE.equals(xa.getAttribute("allowRollback"))) {
            throw new IllegalStateException(L.l("getRollbackOnly() called in forbidden context"));
        }
        return xa.isRollbackOnly();
    }

    public void destroy() throws Exception {
        this._isDead = true;
    }

    public Class<?> getInvokedBusinessInterface() throws IllegalStateException {
        if (this._invokedBusinessInterface == null) {
            throw new IllegalStateException(L.l("SessionContext.getInvokedBusinessInterface() is only allowed through EJB 3.0 interfaces"));
        }
        return this._invokedBusinessInterface;
    }

    public void __caucho_setInvokedBusinessInterface(Class<?> invokedBusinessInterface) {
        this._invokedBusinessInterface = invokedBusinessInterface;
    }

    public void __caucho_timeout_callback(Timer timer) {
        throw new IllegalStateException(L.l("'{0}' does not have a @Timeout callback", (Object)this.getClass().getName()));
    }

    public void __caucho_timeout_callback(Method method) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalStateException(L.l("'{0}' does not have a @Timeout callback", (Object)this.getClass().getName()));
    }

    public void __caucho_timeout_callback(Method method, Timer timer) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalStateException(L.l("'{0}' does not have a @Timeout callback", (Object)this.getClass().getName()));
    }
}

