/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.message;

import com.caucho.ejb.message.MessageManager;
import com.caucho.ejb.server.AbstractContext;
import com.caucho.ejb.server.AbstractEjbBeanManager;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.MessageDrivenContext;
import javax.transaction.UserTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDrivenContextImpl<X>
extends AbstractContext<X>
implements MessageDrivenContext {
    protected static final L10N L = new L10N(MessageDrivenContextImpl.class);
    protected static final Logger log = Logger.getLogger(MessageDrivenContextImpl.class.getName());
    private MessageManager<X> _server;
    private UserTransaction _ut;

    MessageDrivenContextImpl(MessageManager<X> server, UserTransaction ut) {
        this._server = server;
        this._ut = ut;
    }

    @Override
    public AbstractEjbBeanManager<X> getServer() {
        return this._server;
    }

    public boolean isCMT() {
        return this.getServer().isContainerTransaction();
    }

    @Override
    public EJBHome getEJBHome() {
        throw new IllegalStateException(L.l("Message-driven beans may not use getEJBHome()"));
    }

    @Override
    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (this.isCMT()) {
            throw new IllegalStateException(L.l("Container-managed message-driven beans may not use getUserTransaction()"));
        }
        return this._ut;
    }

    void clearRollbackOnly() {
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        if (!this.isCMT()) {
            throw new IllegalStateException("setRollbackOnly may not be called from a bean-managed transaction");
        }
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            TransactionImpl trans = tm.getTransaction();
            if (trans == null) {
                throw new IllegalStateException(L.l("setRollbackOnly called with no active transaction"));
            }
            trans.setRollbackOnly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    @Override
    public boolean getRollbackOnly() throws IllegalStateException {
        if (!this.isCMT()) {
            throw new IllegalStateException("getRollbackOnly may not be called from a bean-managed transaction");
        }
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            TransactionImpl trans = tm.getTransaction();
            if (trans != null) {
                return trans.getStatus() == 1;
            }
            throw new IllegalStateException("getRollbackOnly requires a valid container-managed transaction");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._server.getAnnotatedType().getJavaClass() + "]";
    }
}

