/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.inject;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.inject.ScheduleBean;
import com.caucho.config.timer.ScheduleIntrospector;
import com.caucho.config.timer.TimeoutCaller;
import com.caucho.config.timer.TimerTask;
import com.caucho.ejb.gen.SessionGenerator;
import com.caucho.ejb.inject.SessionBeanImpl;
import com.caucho.ejb.session.StatelessContext;
import com.caucho.ejb.session.StatelessManager;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.ejb.Timer;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class StatelessBeanImpl<X, T>
extends SessionBeanImpl<X, T>
implements ScheduleBean {
    private static final L10N L = new L10N(StatelessBeanImpl.class);
    private LinkedHashSet<Annotation> _qualifiers = new LinkedHashSet();
    private final StatelessManager<X> _manager;

    public StatelessBeanImpl(StatelessManager<X> manager, ManagedBeanImpl<X> bean, Class<T> api, Set<Type> types, StatelessContext<X, T> context, AnnotatedType<X> extAnnType) {
        super(context, bean, types, extAnnType);
        this._manager = manager;
        this._qualifiers.addAll(bean.getQualifiers());
        Class<Annotation> scopeType = bean.getScope();
        if (scopeType != null && !scopeType.equals(Dependent.class)) {
            throw new ConfigException(L.l("@{0} is an invalid scope for @Stateless session bean {1} because stateless session beans need @Dependent scope", (Object)scopeType.getName(), (Object)this.getBeanClass().getName()));
        }
        this.getBean().setPassivating(true);
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this._qualifiers;
    }

    @Override
    public void scheduleTimers(Object value) {
        StatelessScheduleIntrospector introspector = new StatelessScheduleIntrospector();
        StatelessTimeoutCaller timeoutCaller = new StatelessTimeoutCaller(value);
        ArrayList<TimerTask> taskList = introspector.introspect(timeoutCaller, this.getBean().getAnnotatedType());
        if (taskList != null) {
            for (TimerTask task : taskList) {
                task.start();
            }
        }
    }

    private class StatelessTimeoutCaller
    implements TimeoutCaller {
        private final Object _bean;

        public StatelessTimeoutCaller(Object bean) {
            this._bean = bean;
        }

        public void timeout(Method method, Timer timer) throws InvocationTargetException, IllegalAccessException {
            method.invoke(this._bean, timer);
        }

        public void timeout(Method method) throws InvocationTargetException, IllegalAccessException {
            method.invoke(this._bean, new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatelessScheduleIntrospector
    extends ScheduleIntrospector {
        private StatelessScheduleIntrospector() {
        }

        @Override
        protected Method getScheduledMethod(AnnotatedMethod<?> method) {
            Method javaMethod = method.getJavaMember();
            String methodName = javaMethod.getName();
            if (!SessionGenerator.isBusinessMethod(javaMethod)) {
                methodName = "__caucho_schedule_" + javaMethod.getName();
            }
            Class<?> proxyClass = StatelessBeanImpl.this._manager.getProxyImplClass();
            try {
                Method scheduleMethod = proxyClass.getMethod(methodName, javaMethod.getParameterTypes());
                return scheduleMethod;
            }
            catch (Exception e) {
                throw new ConfigException(L.l("Cannot find method {0} on generated class {1}.", (Object)methodName, (Object)proxyClass.getName()), e);
            }
        }
    }
}

