/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.MethodHeadGenerator;
import com.caucho.ejb.gen.StatefulMethodHeadFactory;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.ejb.Remove;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.inject.spi.AnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class StatefulMethodHeadGenerator<X>
extends MethodHeadGenerator<X> {
    private long _lockTimeout;
    private TimeUnit _lockTimeoutUnit;

    public StatefulMethodHeadGenerator(StatefulMethodHeadFactory<X> factory, AnnotatedMethod<? super X> method, AspectGenerator<X> next) {
        super(factory, method, next);
        this._lockTimeout = -1L;
        this._lockTimeoutUnit = null;
    }

    public StatefulMethodHeadGenerator(StatefulMethodHeadFactory<X> factory, AnnotatedMethod<? super X> method, AspectGenerator<X> next, long lockTimeout, TimeUnit lockTimeoutUnit) {
        super(factory, method, next);
        if (lockTimeoutUnit != null) {
            this._lockTimeout = lockTimeout;
            this._lockTimeoutUnit = lockTimeoutUnit;
        } else {
            this._lockTimeout = -1L;
            this._lockTimeoutUnit = null;
        }
    }

    protected TransactionAttributeType getDefaultTransactionType() {
        return TransactionAttributeType.REQUIRED;
    }

    @Override
    public void generateMethodPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        if (map.get("caucho.ejb.semaphore") == null) {
            map.put("caucho.ejb.semaphore", "done");
            out.println();
            out.println("private transient final java.util.concurrent.Semaphore _semaphore = new java.util.concurrent.Semaphore(1);");
        }
        super.generateMethodPrologue(out, map);
    }

    @Override
    public void generatePreTry(JavaWriter out) throws IOException {
        super.generatePreTry(out);
        String beanClassName = this.getJavaClass().getName();
        out.println(beanClassName + " bean = _bean;");
        out.println("__caucho_validate();");
        out.println();
        if (this._lockTimeout != -1L) {
            out.println("try {");
            out.pushDepth();
            out.println("if (!_semaphore.tryAcquire(" + this._lockTimeoutUnit.toMillis(this._lockTimeout) + "L, java.util.concurrent.TimeUnit.MILLISECONDS))");
            out.pushDepth();
            out.println("throw new ConcurrentAccessTimeoutException(\"Timed out acquiring semaphore " + this._lockTimeout + " ms.\");");
            out.popDepth();
            out.println("} catch (InterruptedException e) {");
            out.pushDepth();
            out.println("throw new ConcurrentAccessTimeoutException(\"Thread interruption acquiring semaphore: \" + e.getMessage());");
            out.popDepth();
            out.println("}");
        } else {
            out.println("try {");
            out.pushDepth();
            out.println("_semaphore.acquire();");
            out.popDepth();
            out.println("} catch (InterruptedException e) {");
            out.pushDepth();
            out.println("throw new ConcurrentAccessTimeoutException(\"Thread interruption acquiring semaphore: \" + e.getMessage());");
            out.popDepth();
            out.println("}");
        }
        out.println("boolean isValid = false;");
        out.println("Thread thread = Thread.currentThread();");
        out.println("ClassLoader oldLoader = thread.getContextClassLoader();");
    }

    @Override
    public void generatePreCall(JavaWriter out) throws IOException {
        out.println("thread.setContextClassLoader(_manager.getClassLoader());");
        out.println("_context.startLocal(this);");
        super.generatePreCall(out);
    }

    @Override
    public void generateCall(JavaWriter out) throws IOException {
        super.generateCall(out);
    }

    @Override
    public void generatePostCall(JavaWriter out) throws IOException {
        out.println("isValid = true;");
        super.generatePostCall(out);
    }

    @Override
    public void generateApplicationException(JavaWriter out, Class<?> exn) throws IOException {
        super.generateApplicationException(out, exn);
        if (this.getMethod().getAnnotation(Remove.class) == null) {
            out.println("isValid = true;");
        }
    }

    @Override
    public void generateFinally(JavaWriter out) throws IOException {
        out.println();
        out.println("_semaphore.release();");
        out.println("_context.endLocal(null);");
        out.println("boolean isValidFinally = false;");
        out.println("try {");
        out.pushDepth();
        super.generateFinally(out);
        out.println("isValidFinally = isValid;");
        out.popDepth();
        out.println("} finally {");
        out.pushDepth();
        Remove remove = this.getMethod().getAnnotation(Remove.class);
        if (remove != null) {
            boolean isRetainIfException = remove.retainIfException();
            if (isRetainIfException) {
                out.println("if (isValid)");
                out.println("  __caucho_destroy(null);");
            } else {
                out.println("  __caucho_destroy(null);");
            }
        } else {
            out.println("if (! isValidFinally) {");
            out.println("  __caucho_destroy(null);");
            out.println("}");
        }
        out.println("thread.setContextClassLoader(oldLoader);");
        out.popDepth();
        out.println("}");
    }
}

