/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.index.BTree;
import com.caucho.db.index.KeyCompare;
import com.caucho.db.index.SqlIndexAlreadyExistsException;
import com.caucho.db.index.StringKeyCompare;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.Column;
import com.caucho.db.table.Row;
import com.caucho.db.xa.DbTransaction;
import com.caucho.util.L10N;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringColumn
extends Column {
    private static final L10N L = new L10N(StringColumn.class);
    private final int _maxLength;

    StringColumn(Row row, String name, int maxLength) {
        super(row, name);
        if (maxLength < 0) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        if (255 < maxLength) {
            throw new IllegalArgumentException("length too big");
        }
        this._maxLength = maxLength;
    }

    @Override
    public Column.ColumnType getTypeCode() {
        return Column.ColumnType.VARCHAR;
    }

    @Override
    public Class<?> getJavaType() {
        return String.class;
    }

    @Override
    public int getDeclarationSize() {
        return this._maxLength;
    }

    @Override
    public int getLength() {
        return 2 * this._maxLength + 1;
    }

    @Override
    public KeyCompare getIndexKeyCompare() {
        return new StringKeyCompare();
    }

    @Override
    void setString(DbTransaction xa, byte[] block, int rowOffset, String str) {
        int offset = rowOffset + this._columnOffset;
        if (str == null) {
            this.setNull(block, rowOffset);
            return;
        }
        int len = str.length();
        int maxOffset = offset + 2 * this._maxLength + 1;
        block[offset++] = (byte)len;
        for (int i = 0; i < len && offset < maxOffset; ++i) {
            char ch = str.charAt(i);
            block[offset++] = (byte)(ch >> 8);
            block[offset++] = (byte)ch;
        }
        this.setNonNull(block, rowOffset);
    }

    @Override
    public String getString(long blockId, byte[] block, int rowOffset) {
        if (this.isNull(block, rowOffset)) {
            return null;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = block[startOffset] & 0xFF;
        char[] cBuf = new char[len];
        int offset = startOffset + 1;
        int endOffset = offset + 2 * len;
        int i = 0;
        while (offset < endOffset) {
            int ch1 = block[offset++] & 0xFF;
            int ch2 = block[offset++] & 0xFF;
            cBuf[i++] = (char)((ch1 << 8) + ch2);
        }
        return new String(cBuf, 0, cBuf.length);
    }

    @Override
    void setExpr(DbTransaction xa, byte[] block, int rowOffset, Expr expr, QueryContext context) throws SQLException {
        if (expr.isNull(context)) {
            this.setNull(block, rowOffset);
        } else {
            this.setString(xa, block, rowOffset, expr.evalString(context));
        }
    }

    @Override
    public boolean isEqual(byte[] block1, int rowOffset1, byte[] block2, int rowOffset2) {
        if (this.isNull(block1, rowOffset1) != this.isNull(block2, rowOffset2)) {
            return false;
        }
        int startOffset1 = rowOffset1 + this._columnOffset;
        int len1 = block1[startOffset1] & 0xFF;
        int startOffset2 = rowOffset2 + this._columnOffset;
        int len2 = block2[startOffset2] & 0xFF;
        if (len1 != len2) {
            return false;
        }
        for (int i = 2 * len1; i > 0; --i) {
            if (block1[startOffset1 + i] == block2[startOffset2 + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(byte[] block, int rowOffset, byte[] buffer, int offset, int length) {
        if (this.isNull(block, rowOffset)) {
            return false;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = block[startOffset] & 0xFF;
        if (len != length) {
            return false;
        }
        int blockOffset = startOffset + 1;
        int endOffset = blockOffset + 2 * len;
        while (blockOffset < endOffset) {
            if (block[blockOffset++] == buffer[offset++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(long blockId, byte[] block, int rowOffset, String value) {
        if (value == null) {
            return this.isNull(block, rowOffset);
        }
        if (this.isNull(block, rowOffset)) {
            return false;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = block[startOffset] & 0xFF;
        int strLength = value.length();
        int strOffset = 0;
        int offset = startOffset + 1;
        int endOffset = offset + 2 * len;
        while (offset < endOffset && strOffset < strLength) {
            char ch;
            int ch1;
            if ((ch1 = ((block[offset++] & 0xFF) << 8) + (block[offset++] & 0xFF)) == (ch = value.charAt(strOffset++))) continue;
            return false;
        }
        return offset == endOffset && strOffset == strLength;
    }

    @Override
    public void evalToResult(long blockId, byte[] block, int rowOffset, SelectResult result) {
        if (this.isNull(block, rowOffset)) {
            result.writeNull();
            return;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = block[startOffset] & 0xFF;
        result.writeString(block, startOffset + 1, len);
    }

    @Override
    int evalToBuffer(byte[] block, int rowOffset, byte[] buffer, int bufferOffset) throws SQLException {
        if (this.isNull(block, rowOffset)) {
            return 0;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = this.getLength();
        System.arraycopy(block, startOffset, buffer, bufferOffset, len);
        return len;
    }

    @Override
    void setIndex(DbTransaction xa, byte[] block, int rowOffset, long rowAddr, QueryContext context) throws SQLException {
        BTree index = this.getIndex();
        if (index != null) {
            try {
                index.insert(block, rowOffset + this._columnOffset, this.getLength(), rowAddr, false);
            }
            catch (SqlIndexAlreadyExistsException e) {
                long blockId = 0L;
                throw new SqlIndexAlreadyExistsException(L.l("StringColumn '{0}.{1}' unique index set failed for {2}.\n{3}", (Object)this.getTable().getName(), (Object)this.getName(), (Object)this.getString(blockId, block, rowOffset), (Object)e.toString()), e);
            }
        }
    }

    @Override
    void deleteIndex(DbTransaction xa, byte[] block, int rowOffset) throws SQLException {
        BTree index = this.getIndex();
        if (index != null) {
            index.remove(block, rowOffset + this._columnOffset, this.getLength());
        }
    }

    @Override
    public String toString() {
        if (this.getIndex() != null) {
            return this.getClass().getSimpleName() + "[" + this.getName() + ",index]";
        }
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

