/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.Database;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SetItem;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.DbTransaction;
import com.caucho.util.SQLExceptionWrapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;

class UpdateQuery
extends Query {
    private static final Logger log = Logger.getLogger(UpdateQuery.class.getName());
    private final Table _table;
    private SetItem[] _setItems;

    UpdateQuery(Database db, String sql, Table table) throws SQLException {
        super(db, sql, null);
        this._table = table;
        this.setFromItems(new FromItem[]{new FromItem(table, table.getName())});
    }

    public void setSetItems(SetItem[] setItems) {
        this._setItems = setItems;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected void bind() throws SQLException {
        super.bind();
        for (int i = 0; i < this._setItems.length; ++i) {
            Expr expr = this._setItems[i].getExpr();
            expr = expr.bind(this);
            this._setItems[i].setExpr(expr);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(QueryContext context, DbTransaction xa) throws SQLException {
        TableIterator[] rows;
        block9: {
            block8: {
                int count = 0;
                SetItem[] setItems = this._setItems;
                rows = new TableIterator[]{this._table.createTableIterator()};
                context.init(xa, rows, this.isReadOnly());
                try {
                    try {
                        if (!this.start(rows, rows.length, context, xa)) {
                            Object var11_6 = null;
                            break block8;
                        }
                        do {
                            TableIterator iter = rows[0];
                            for (int i = 0; i < setItems.length; ++i) {
                                Column column = setItems[i].getColumn();
                                Expr expr = setItems[i].getExpr();
                                column.set(xa, iter, expr, context);
                            }
                            context.setRowUpdateCount(++count);
                        } while (this.nextTuple(rows, rows.length, context, xa));
                        break block9;
                    }
                    catch (IOException e) {
                        throw new SQLExceptionWrapper(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_8 = null;
                    context.close();
                    this.freeRows(rows, rows.length);
                    throw throwable;
                }
            }
            context.close();
            this.freeRows(rows, rows.length);
            return;
        }
        Object var11_7 = null;
        context.close();
        this.freeRows(rows, rows.length);
    }

    public String toString() {
        StringBuilder cb = new StringBuilder();
        cb.append("UpdateQuery[");
        if (this._whereExpr != null) {
            cb.append(",where:" + this._whereExpr);
        }
        cb.append("]");
        return cb.toString();
    }
}

