/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnboundIdentifierExpr
extends Expr {
    private static final L10N L = new L10N(UnboundIdentifierExpr.class);
    private String _table;
    private String _column;

    UnboundIdentifierExpr(String column) {
        this._column = column;
    }

    UnboundIdentifierExpr(String table, String column) {
        this._table = table;
        this._column = column;
    }

    protected long lookupCost(ArrayList<FromItem> fromList) {
        Column column = this.findColumn(fromList);
        if (column == null) {
            return Integer.MAX_VALUE;
        }
        FromItem fromItem = fromList.get(fromList.size() - 1);
        Table table = fromItem.getTable();
        column = table.getColumn(this._column);
        if (column == null) {
            return 1000000L;
        }
        if (column.isPrimaryKey()) {
            return 100L;
        }
        if (column.isUnique()) {
            return 10000L;
        }
        return 1000000L;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        Column column = this.findColumn(fromList);
        if (column == null) {
            return Integer.MAX_VALUE;
        }
        return 10000000L;
    }

    private Column findColumn(ArrayList<FromItem> fromItems) {
        if (this._table == null) {
            for (int i = 0; i < fromItems.size(); ++i) {
                FromItem fromItem = fromItems.get(i);
                Table table = fromItem.getTable();
                Column column = table.getColumn(this._column);
                if (column == null) continue;
                return column;
            }
            return null;
        }
        for (int i = 0; i < fromItems.size(); ++i) {
            FromItem fromItem = fromItems.get(i);
            if (!this._table.equals(fromItem.getName())) continue;
            Table table = fromItem.getTable();
            return table.getColumn(this._column);
        }
        return null;
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        return query.bind(this._table, this._column);
    }

    public String toString() {
        if (this._table != null) {
            return "UnboundIdentifier[" + this._table + "," + this._column + "]";
        }
        return "UnboundIdentifier[" + this._column + "]";
    }
}

