/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NotExpr
extends Expr {
    private Expr _sub;

    NotExpr(Expr sub) {
        this._sub = sub;
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        this._sub = this._sub.bind(query);
        if (!this._sub.isBoolean()) {
            throw new SQLException(L.l("NOT requires a boolean expression"));
        }
        return this;
    }

    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._sub.subCost(fromList);
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return this._sub.isNull(context);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        int value = this._sub.evalBoolean(context);
        switch (value) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        return -1;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        int value = this._sub.evalBoolean(context);
        switch (value) {
            case 1: {
                return "1";
            }
            case 0: {
                return "0";
            }
        }
        return null;
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._sub.evalGroup(context);
    }

    public String toString() {
        return "NOT " + this._sub;
    }
}

