/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.index.BTree;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.IdExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.RowIterateExpr;
import com.caucho.db.table.Column;
import com.caucho.db.table.TableIterator;
import java.io.IOException;
import java.sql.SQLException;

class IndexExpr
extends RowIterateExpr {
    private IdExpr _columnExpr;
    private Column _column;
    private BTree _index;
    private Expr _expr;

    IndexExpr(IdExpr index, Expr expr) {
        this._expr = expr;
        this._columnExpr = index;
        if (expr == null || index == null) {
            throw new NullPointerException();
        }
        this._column = index.getColumn();
        this._index = this._column.getIndex();
        if (this._index == null) {
            throw new IllegalArgumentException();
        }
    }

    public Expr bind(Query query) throws SQLException {
        this._expr = this._expr.bind(query);
        return this;
    }

    boolean allowChildRowShift(QueryContext context, TableIterator rowIter) {
        return false;
    }

    boolean init(QueryContext context, TableIterator rowIter) throws SQLException, IOException {
        rowIter.init(context);
        return true;
    }

    boolean initRow(QueryContext context, TableIterator tableIter) throws SQLException, IOException {
        long rowAddr = this.evalIndex(context);
        if (rowAddr == 0L) {
            return false;
        }
        tableIter.setRow(rowAddr);
        return true;
    }

    boolean nextRow(QueryContext context, TableIterator table) {
        return false;
    }

    boolean nextBlock(QueryContext context, TableIterator rowIter) throws IOException, SQLException {
        return false;
    }

    long evalIndex(QueryContext context) throws SQLException {
        long index;
        byte[] buffer = context.getBuffer();
        int length = this._expr.evalToBuffer(context, buffer, 0, this._column.getTypeCode());
        if (length <= 0) {
            return 0L;
        }
        try {
            index = this._index.lookup(buffer, 0, length);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return index;
    }

    public String toString() {
        return "(" + this._columnExpr + " = " + this._expr + ")";
    }
}

