/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.blob.BlobInputStream;
import com.caucho.db.blob.Inode;
import com.caucho.db.block.BlockStore;
import com.caucho.util.L10N;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobImpl
implements Blob {
    private static final L10N L = new L10N(BlobImpl.class);
    private BlockStore _store;
    private byte[] _inode = new byte[128];

    BlobImpl() {
    }

    void setStore(BlockStore store) {
        this._store = store;
    }

    byte[] getInode() {
        return this._inode;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new BlobInputStream(this._store, this._inode, 0);
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        try {
            int ch;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            InputStream is = this.getBinaryStream();
            if (pos > 1L) {
                is.skip(pos - 1L);
            }
            for (int i = 0; i < length && (ch = is.read()) >= 0; ++i) {
                bos.write(ch);
            }
            is.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public long length() throws SQLException {
        return BlobInputStream.readLong(this._inode, 0);
    }

    public void writeToStream(OutputStream out) throws IOException {
        long length = BlobInputStream.readLong(this._inode, 0);
        Inode.writeToStream(this._inode, 0, this._store, out, 0L, length);
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void truncate(long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void free() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

