/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.block;

import com.caucho.db.block.Block;
import com.caucho.db.block.BlockStore;
import com.caucho.db.block.BlockWriteQueue;
import com.caucho.env.thread.AbstractTaskWorker;
import com.caucho.util.CurrentTime;
import com.caucho.util.RingValueQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockWriter
extends AbstractTaskWorker {
    private static final Logger log = Logger.getLogger(BlockWriter.class.getName());
    private final BlockStore _store;
    private final BlockWriteQueue _blockWriteQueue = new BlockWriteQueue(this);
    private int _queueSize = 1024;
    private final RingValueQueue<Block> _blockWriteRing = new RingValueQueue(this._queueSize);

    BlockWriter(BlockStore store) {
        this._store = store;
        store.getReadWrite();
    }

    void addDirtyBlock(Block block) {
        this.addDirtyBlockNoWake(block);
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void XX_addDirtyBlockNoWake(Block block) {
        boolean isWake = false;
        BlockWriteQueue blockWriteQueue = this._blockWriteQueue;
        synchronized (blockWriteQueue) {
            if (this._blockWriteQueue.isFilled()) {
                isWake = true;
            }
            this._blockWriteQueue.addDirtyBlock(block);
        }
        if (isWake) {
            this.wake();
        }
    }

    void addDirtyBlockNoWake(Block block) {
        if (this._blockWriteRing.offer(block, 0L, TimeUnit.SECONDS)) {
            return;
        }
        this.wake();
        if (this.isClosed()) {
            return;
        }
        if (!this._blockWriteRing.offer(block, 60L, TimeUnit.SECONDS)) {
            System.err.println("OFFER_FAILED: " + block + " head:" + this._blockWriteRing.getHead() + " tail:" + this._blockWriteRing.getTail());
        }
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean XX_copyDirtyBlock(long blockId, Block block) {
        Block writeBlock = null;
        BlockWriteQueue blockWriteQueue = this._blockWriteQueue;
        synchronized (blockWriteQueue) {
            writeBlock = this._blockWriteQueue.findBlock(blockId);
        }
        if (writeBlock != null) {
            return writeBlock.copyToBlock(block);
        }
        return false;
    }

    boolean copyDirtyBlock(long blockId, Block block) {
        Block writeBlock;
        while ((writeBlock = this.findBlock(blockId)) != null && !writeBlock.copyToBlock(block)) {
        }
        return writeBlock != null;
    }

    private Block findBlock(long blockId) {
        long ptr = this._blockWriteRing.getTail();
        Block matchBlock = null;
        while (ptr < this._blockWriteRing.getHead()) {
            Block testBlock = this._blockWriteRing.getValue(ptr);
            if (testBlock == null) {
                ptr = Math.max(ptr, this._blockWriteRing.getTail());
                continue;
            }
            ++ptr;
            if (testBlock.getBlockId() != blockId) continue;
            matchBlock = testBlock;
        }
        return matchBlock;
    }

    boolean XX_waitForComplete(long timeout) {
        this.wake();
        this._blockWriteQueue.waitForComplete(timeout);
        return true;
    }

    boolean waitForComplete(long timeout) {
        this.wake();
        long expire = CurrentTime.getCurrentTimeActual() + timeout;
        while (!this.isClosed() && !this._blockWriteRing.isEmpty() && CurrentTime.getCurrentTimeActual() < expire) {
            this.wake();
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {}
        }
        return this._blockWriteRing.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long runTask() {
        try {
            int retryMax;
            int retry = retryMax = 25;
            while (true) {
                Block block;
                if ((block = this.peekFirstBlock()) != null) {
                    retry = retryMax;
                    try {
                        block.writeFromBlockWriter();
                    }
                    finally {
                        this.removeFirstBlock();
                    }
                    continue;
                }
                if (this.isQueueEmpty() && retry-- <= 0) break;
            }
            return -1L;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return -1L;
        }
    }

    private boolean isQueueEmpty() {
        return this._blockWriteRing.isEmpty();
    }

    private Block peekFirstBlock() {
        return this._blockWriteRing.peek();
    }

    private void removeFirstBlock() {
        this._blockWriteRing.poll();
    }

    protected void onThreadStart() {
    }

    protected void onThreadComplete() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._store + "]";
    }
}

