/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.scope;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.scope.ScopeRemoveListener;
import com.caucho.inject.Module;
import java.io.Serializable;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class ContextContainer
implements Serializable,
ScopeRemoveListener {
    private transient InjectManager _beanManager = InjectManager.create();
    private ContextItem<?> _values;

    public Object get(Object id) {
        if (id == null) {
            return null;
        }
        for (ContextItem<?> ptr = this._values; ptr != null; ptr = ptr.getNext()) {
            if (!id.equals(ptr.getId())) continue;
            return ptr.getObject();
        }
        return null;
    }

    public <T> T get(Contextual<T> bean) {
        for (ContextItem<?> ptr = this._values; ptr != null; ptr = ptr.getNext()) {
            if (bean != ptr.getBean()) continue;
            return (T)ptr.getObject();
        }
        return null;
    }

    public <T> void put(Contextual<T> bean, Object id, T value, CreationalContext<T> env) {
        this._values = new ContextItem<T>(this._values, bean, id, value, env);
    }

    @Override
    public void removeEvent(Object scope, String name) {
        this.close();
    }

    public synchronized BeanManager getBeanManager() {
        if (this._beanManager == null) {
            this._beanManager = InjectManager.create();
        }
        return this._beanManager;
    }

    public void close() {
        this._values = null;
        for (ContextItem<?> entry = this._values; entry != null; entry = entry.getNext()) {
            Contextual<?> bean = entry.getBean();
            Object id = entry.getId();
            Object value = entry.getObject();
            if (bean == null && id instanceof String) {
                BeanManager beanManager = this.getBeanManager();
                bean = beanManager.getPassivationCapableBean((String)id);
            }
            CreationalContext<?> env = entry.getEnv();
            bean.destroy(value, env);
            if (env == null) continue;
            env.release();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ContextItem<T>
    implements Serializable {
        private final ContextItem<?> _next;
        private final transient Contextual<T> _bean;
        private final Object _id;
        private final T _object;
        private final transient CreationalContext<T> _env;

        ContextItem(ContextItem<?> next, Contextual<T> bean, Object id, T object, CreationalContext<T> env) {
            this._next = next;
            this._bean = bean;
            this._id = id;
            this._object = object;
            this._env = env;
        }

        ContextItem<?> getNext() {
            return this._next;
        }

        Contextual<T> getBean() {
            return this._bean;
        }

        Object getId() {
            return this._id;
        }

        T getObject() {
            return this._object;
        }

        CreationalContext<T> getEnv() {
            return this._env;
        }
    }
}

